/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;

public class DwgSpline
extends DwgObject
implements IDwg3DTestable,
IDwg2FMap {
    private int scenario;
    private int degree;
    private double fitTolerance;
    private double[] beginTanVector;
    private double[] endTanVector;
    private boolean rational;
    private boolean closed;
    private boolean periodic;
    private double knotTolerance;
    private double controlTolerance;
    private double[] knotPoints;
    private double[][] controlPoints;
    private double[] weights;
    private double[][] fitPoints;

    public DwgSpline(int index) {
        super(index);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public double[][] getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(double[][] controlPoints) {
        this.controlPoints = controlPoints;
    }

    public double[][] getFitPoints() {
        return this.fitPoints;
    }

    public void setFitPoints(double[][] fitPoints) {
        this.fitPoints = fitPoints;
    }

    public double[] getKnotPoints() {
        return this.knotPoints;
    }

    public void setKnotPoints(double[] knotPoints) {
        this.knotPoints = knotPoints;
    }

    public int getScenario() {
        return this.scenario;
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public double[] getBeginTanVector() {
        return this.beginTanVector;
    }

    public void setBeginTanVector(double[] beginTanVector) {
        this.beginTanVector = beginTanVector;
    }

    public double getControlTolerance() {
        return this.controlTolerance;
    }

    public void setControlTolerance(double controlTolerance) {
        this.controlTolerance = controlTolerance;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public double[] getEndTanVector() {
        return this.endTanVector;
    }

    public void setEndTanVector(double[] endTanVector) {
        this.endTanVector = endTanVector;
    }

    public double getFitTolerance() {
        return this.fitTolerance;
    }

    public void setFitTolerance(double fitTolerance) {
        this.fitTolerance = fitTolerance;
    }

    public double getKnotTolerance() {
        return this.knotTolerance;
    }

    public void setKnotTolerance(double knotTolerance) {
        this.knotTolerance = knotTolerance;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public boolean isRational() {
        return this.rational;
    }

    public void setRational(boolean rational) {
        this.rational = rational;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    @Override
    public boolean has3DData() {
        double[][] pts = this.getControlPoints();
        if (pts == null) {
            return false;
        }
        double z = 0.0;
        for (int j = 0; j < pts.length; ++j) {
            z = pts[j][2];
            if (z == 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZ() {
        return 0.0;
    }

    @Override
    public Object clone() {
        DwgSpline obj = new DwgSpline(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgSpline myObj = (DwgSpline)obj;
        myObj.setBeginTanVector(this.beginTanVector);
        myObj.setClosed(this.closed);
        myObj.setControlPoints(this.controlPoints);
        myObj.setControlTolerance(this.controlTolerance);
        myObj.setDegree(this.degree);
        myObj.setEndTanVector(this.endTanVector);
        myObj.setFitPoints(this.fitPoints);
        myObj.setFitTolerance(this.fitTolerance);
        myObj.setKnotPoints(this.knotPoints);
        myObj.setKnotTolerance(this.knotTolerance);
        myObj.setPeriodic(this.periodic);
        myObj.setRational(this.rational);
        myObj.setScenario(this.scenario);
        myObj.setWeights(this.weights);
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        Spline pline = null;
        int subType = this.getGeometrySubType(is3DFile);
        double elev = this.getZ();
        double[][] points = this.getFitPoints();
        if (points == null) {
            points = this.getControlPoints();
        }
        if (points == null) {
            gMan.createNullGeometry(subType);
        }
        pline = (Spline)gMan.create(this.getGeometryType(), subType);
        for (int i = 0; i < points.length; ++i) {
            Point point = (Point)gMan.create(1, subType);
            pline.addVertex(point);
        }
        return pline;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Spline";
    }

    @Override
    public int getGeometryType() {
        return 14;
    }
}

