/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.dwg.lib.ByteUtils;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgClass;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgObjectFactory;
import org.gvsig.dwg.lib.DwgObjectOffset;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.readers.DwgObjectReaderPool;
import org.gvsig.dwg.lib.readers.IDwgFileReader;
import org.gvsig.dwg.lib.readers.IDwgObjectReader;
import org.gvsig.dwg.lib.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgFileV15Reader
implements IDwgFileReader {
    protected DwgFile dwgFile;
    protected ByteBuffer bb;
    private static Logger logger = LoggerFactory.getLogger((String)DwgFileV15Reader.class.getName());

    @Override
    public void read(DwgFile dwgFile, ByteBuffer bb) throws IOException {
        this.dwgFile = dwgFile;
        this.bb = bb;
        try {
            this.readDwgSectionOffsets();
            this.readHeaders();
            this.readDwgClasses();
            this.readDwgObjectOffsets();
            this.readDwgObjects();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    protected void checkSuperentities() {
        logger.info("***** CHEQUEANDO LAS SUPERENTIDADES *****");
        List objects = this.dwgFile.getDwgObjects();
        boolean buscado = false;
        boolean perdidos = false;
        int j = 0;
        for (int i = 0; i < objects.size(); ++i) {
            DwgObject obj = (DwgObject)objects.get(i);
            if (!obj.hasSubEntityHandle()) continue;
            buscado = true;
            DwgObject superEnt = this.dwgFile.getDwgSuperEntity(obj);
            if (superEnt != null) continue;
            ++j;
        }
        if (j != 0) {
            logger.warn("+++++ SE HAN PERDIDO LAS SUPERENTIDADES DE " + j + " OBJETOS +++++");
        }
        logger.info("***** FIN DEL CHEQUEO DE LAS SUPERENTIDADES *****");
    }

    protected void readDwgSectionOffsets() {
        this.bb.position(19);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short codePage = this.bb.getShort();
        int count = this.bb.getInt();
        for (int i = 0; i < count; ++i) {
            byte rec = this.bb.get();
            int seek = this.bb.getInt();
            int size = this.bb.getInt();
            if (rec == 0) {
                this.dwgFile.addDwgSectionOffset("HEADERS", seek, size);
                continue;
            }
            if (rec == 1) {
                this.dwgFile.addDwgSectionOffset("CLASSES", seek, size);
                continue;
            }
            if (rec == 2) {
                this.dwgFile.addDwgSectionOffset("OBJECTS", seek, size);
                continue;
            }
            if (rec == 3) {
                this.dwgFile.addDwgSectionOffset("UNKNOWN", seek, size);
                continue;
            }
            if (rec == 4) {
                this.dwgFile.addDwgSectionOffset("R14DATA", seek, size);
                continue;
            }
            if (rec != 5) continue;
            this.dwgFile.addDwgSectionOffset("R14REC5", seek, size);
        }
    }

    protected void readDwgObjectOffsets() throws Exception {
        int offset = this.dwgFile.getDwgSectionOffset("OBJECTS");
        this.bb.position(offset);
        block0: while (true) {
            this.bb.order(ByteOrder.BIG_ENDIAN);
            short size = this.bb.getShort();
            if (size == 2) break;
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dataBytes = new byte[size];
            this.bb.get(dataBytes);
            int[] data = DwgUtil.bytesToMachineBytes(dataBytes);
            int lastHandle = 0;
            int lastLoc = 0;
            int bitPos = 0;
            int bitMax = (size - 2) * 8;
            while (true) {
                if (bitPos >= bitMax) continue block0;
                ArrayList v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                lastHandle += ((Integer)v.get(1)).intValue();
                v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                this.dwgFile.addDwgObjectOffset(lastHandle, lastLoc += ((Integer)v.get(1)).intValue());
            }
            break;
        }
    }

    protected void readDwgClasses() throws Exception {
        int offset = this.dwgFile.getDwgSectionOffset("CLASSES");
        this.bb.position(offset);
        this.bb.order(ByteOrder.nativeOrder());
        byte[] sentinel = new byte[16];
        this.bb.get(sentinel);
        if (sentinel[0] != 141) {
            logger.warn("sentinel[0] != 0x8d");
        }
        if (sentinel[1] != 161) {
            logger.warn("sentinel[1] != 0xa1");
        }
        if (sentinel[2] != 196) {
            logger.warn("sentinel[2] != 0xc4");
        }
        if (sentinel[3] != 184) {
            logger.warn("sentinel[3] != 0xb8");
        }
        if (sentinel[4] != 196) {
            logger.warn("sentinel[4] != 0xc4");
        }
        if (sentinel[5] != 169) {
            logger.warn("sentinel[5] != 0xa9");
        }
        if (sentinel[6] != 248) {
            logger.warn("sentinel[6] != 0xf8");
        }
        if (sentinel[7] != 197) {
            logger.warn("sentinel[7] != 0xc5");
        }
        if (sentinel[8] != 192) {
            logger.warn("sentinel[8] != 0xc0");
        }
        if (sentinel[9] != 220) {
            logger.warn("sentinel[9] != 0xdc");
        }
        if (sentinel[10] != 244) {
            logger.warn("sentinel[10] != 0xf4");
        }
        if (sentinel[11] != 95) {
            logger.warn("sentinel[11] != 0x5f");
        }
        if (sentinel[12] != 231) {
            logger.warn("sentinel[12] != 0xe7");
        }
        if (sentinel[13] != 207) {
            logger.warn("sentinel[13] != 0xcf");
        }
        if (sentinel[14] != 182) {
            logger.warn("sentinel[14] != 0xb6");
        }
        if (sentinel[15] != 138) {
            logger.warn("sentinel[15] != 0x8a");
        }
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = this.bb.getInt();
        byte[] data = new byte[size];
        this.bb.get(data);
        int[] intData = DwgUtil.toIntArray(data);
        short crc = this.bb.getShort();
        int maxBit = size * 8;
        int bitPos = 0;
        ArrayList val = null;
        while (bitPos + 8 < maxBit) {
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int classNum = (Integer)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int version = (Integer)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String appName = (String)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String cPlusPlusName = (String)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String dxfName = (String)val.get(1);
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            boolean isZombie = (Boolean)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int id = (Integer)val.get(1);
            DwgClass dwgClass = new DwgClass(classNum, version, appName, cPlusPlusName, dxfName, isZombie, id);
            this.dwgFile.addDwgClass(dwgClass);
        }
        this.bb.order(ByteOrder.nativeOrder());
        byte[] lastSentinnel = new byte[16];
        this.bb.get(lastSentinnel);
        if (lastSentinnel[0] != 114) {
            logger.warn("lastSentinnel[0] != 0x72");
        }
        if (lastSentinnel[1] != 94) {
            logger.warn("lastSentinnel[1] != 0x5e");
        }
        if (lastSentinnel[2] != 59) {
            logger.warn("lastSentinnel[2] != 0x3b");
        }
        if (lastSentinnel[3] != 71) {
            logger.warn("lastSentinnel[3] != 0x47");
        }
        if (lastSentinnel[4] != 59) {
            logger.warn("lastSentinnel[4] != 0x3b");
        }
        if (lastSentinnel[5] != 86) {
            logger.warn("lastSentinnel[5] != 0x56");
        }
        if (lastSentinnel[6] != 7) {
            logger.warn("lastSentinnel[6] != 0x07");
        }
        if (lastSentinnel[7] != 58) {
            logger.warn("lastSentinnel[7] != 0x3a");
        }
        if (lastSentinnel[8] != 63) {
            logger.warn("lastSentinnel[8] != 0x3f");
        }
        if (lastSentinnel[9] != 35) {
            logger.warn("lastSentinnel[9] != 0x23");
        }
        if (lastSentinnel[10] != 11) {
            logger.warn("lastSentinnel[10] != 0x0b");
        }
        if (lastSentinnel[11] != 160) {
            logger.warn("lastSentinnel[11] != 0xa0");
        }
        if (lastSentinnel[12] != 24) {
            logger.warn("lastSentinnel[12] != 0x18");
        }
        if (lastSentinnel[13] != 48) {
            logger.warn("lastSentinnel[13] != 0x30");
        }
        if (lastSentinnel[14] != 73) {
            logger.warn("lastSentinnel[14] != 0x49");
        }
        if (lastSentinnel[15] != 117) {
            logger.warn("lastSentinnel[15] != 0x75");
        }
    }

    protected void readDwgClasses2() throws Exception {
        int offset = this.dwgFile.getDwgSectionOffset("CLASSES");
        this.bb.position(offset + 16);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = this.bb.getInt();
        byte[] dataBytes = new byte[size];
        for (int i = 0; i < dataBytes.length; ++i) {
            dataBytes[i] = this.bb.get();
        }
        int[] data = DwgUtil.bytesToMachineBytes(dataBytes);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)ByteUtils.getUnsigned((byte)data[i]);
        }
        this.bb.position(this.bb.position() + 2 + 16);
        int maxbit = size * 8;
        int bitPos = 0;
        while (bitPos + 8 < maxbit) {
            ArrayList v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
        }
    }

    protected void readDwgObjects() {
        for (int i = 0; i < this.dwgFile.getDwgObjectOffsets().size(); ++i) {
            try {
                DwgObjectOffset doo = (DwgObjectOffset)this.dwgFile.getDwgObjectOffsets().get(i);
                DwgObject obj = this.readDwgObject(doo.getOffset(), i);
                if (obj == null || obj.getClass() == DwgObject.class) continue;
                this.dwgFile.addDwgObject(obj);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    @Override
    public int readObjectHeader(int[] data, int offset, DwgObject dwgObject) {
        int bitPos = offset;
        Integer mode = (Integer)DwgUtil.getBits(data, 2, bitPos);
        dwgObject.setMode(mode);
        ArrayList v = DwgUtil.getBitShort(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int rnum = (Integer)v.get(1);
        dwgObject.setNumReactors(rnum);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean nolinks = (Boolean)v.get(1);
        dwgObject.setNoLinks(nolinks);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int color = (Integer)v.get(1);
        dwgObject.setColor(color);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        float ltscale = ((Double)v.get(1)).floatValue();
        Integer ltflag = (Integer)DwgUtil.getBits(data, 2, bitPos);
        Integer psflag = (Integer)DwgUtil.getBits(data, 2, bitPos += 2);
        v = DwgUtil.getBitShort(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int invis = (Integer)v.get(1);
        v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        int weight = (Integer)v.get(1);
        return bitPos;
    }

    @Override
    public int readObjectTailer(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        int bitPos = offset;
        if (dwgObject.getMode() == 0) {
            DwgHandleReference subEntityHandle = new DwgHandleReference();
            bitPos = subEntityHandle.read(data, bitPos);
            dwgObject.setSubEntityHandle(subEntityHandle);
        }
        for (int i = 0; i < dwgObject.getNumReactors(); ++i) {
            DwgHandleReference reactorHandle = new DwgHandleReference();
            bitPos = reactorHandle.read(data, bitPos);
            dwgObject.addReactorHandle(reactorHandle);
        }
        DwgHandleReference xDicObjHandle = new DwgHandleReference();
        bitPos = xDicObjHandle.read(data, bitPos);
        dwgObject.setXDicObjHandle(xDicObjHandle);
        DwgHandleReference handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        dwgObject.setLayerHandle(handle);
        if (!dwgObject.isNoLinks()) {
            DwgHandleReference previousHandle = new DwgHandleReference();
            bitPos = previousHandle.read(data, bitPos);
            dwgObject.setPreviousHandle(previousHandle);
            DwgHandleReference nextHandle = new DwgHandleReference();
            bitPos = nextHandle.read(data, bitPos);
            dwgObject.setNextHandle(nextHandle);
        }
        if (dwgObject.getLinetypeFlags() == 3) {
            DwgHandleReference lineTypeHandle = new DwgHandleReference();
            bitPos = lineTypeHandle.read(data, bitPos);
            dwgObject.setLineTypeHandle(lineTypeHandle);
        }
        if (dwgObject.getPlotstyleFlags() == 3) {
            DwgHandleReference plotStyleHandle = new DwgHandleReference();
            bitPos = plotStyleHandle.read(data, bitPos);
            dwgObject.setPlotStyleHandle(plotStyleHandle);
        }
        return bitPos;
    }

    public DwgObject getDwgObjectByIndex(int index) {
        DwgObjectOffset doo = (DwgObjectOffset)this.dwgFile.getDwgObjectOffsets().get(index);
        return this.readDwgObject(doo.getOffset(), index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DwgObject readDwgObject(int offset, int index) {
        DwgObject obj = null;
        try {
            this.bb.position(offset);
            int size = DwgUtil.getModularShort(this.bb);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dataBytes = new byte[size];
            String[] dataMachValString = new String[size];
            int[] data = new int[size];
            for (int i = 0; i < size; ++i) {
                dataBytes[i] = this.bb.get();
                dataMachValString[i] = HexUtil.bytesToHex(new byte[]{dataBytes[i]});
                Integer dataMachValShort = Integer.decode("0x" + dataMachValString[i]);
                data[i] = dataMachValShort.byteValue();
                data[i] = ByteUtils.getUnsigned((byte)data[i]);
            }
            int bitPos = 0;
            ArrayList v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int type = (Integer)v.get(1);
            obj = DwgObjectFactory.getInstance().create(type, index);
            if (obj == null) {
                if (type >= 500) {
                    int newIndex = type - 500;
                    if (newIndex >= this.dwgFile.getDwgClasses().size() - 1) return null;
                    DwgClass dwgClass = (DwgClass)this.dwgFile.getDwgClasses().get(newIndex);
                    String dxfEntityName = dwgClass.getDxfName();
                    obj = DwgObjectFactory.getInstance().create(dxfEntityName, index);
                    if (obj == null) {
                        logger.info(dxfEntityName + " todavia no est\u00ef\u00bf\u00bd implementado");
                        return null;
                    }
                } else {
                    logger.info("Encontrado tipo " + type);
                    return null;
                }
            }
            v = DwgUtil.getRawLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            int objBSize = (Integer)v.get(1);
            obj.setSizeInBits(objBSize);
            DwgHandleReference entityHandle = new DwgHandleReference();
            bitPos = entityHandle.read(data, bitPos);
            obj.setHandle(entityHandle);
            v = DwgUtil.readExtendedData(data, bitPos);
            bitPos = (Integer)v.get(0);
            ArrayList extData = (ArrayList)v.get(1);
            obj.setExtendedData(extData);
            boolean gflag = false;
            gflag = obj.isGraphicsFlag();
            if (gflag) {
                v = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)v.get(0);
                boolean val = (Boolean)v.get(1);
                if (val) {
                    v = DwgUtil.getRawLong(data, bitPos);
                    bitPos = (Integer)v.get(0);
                    size = (Integer)v.get(1);
                    int bgSize = size * 8;
                    Integer giData = (Integer)DwgUtil.getBits(data, bgSize, bitPos);
                    obj.setGraphicData(giData);
                    bitPos += bgSize;
                }
            }
            if (obj.getClass() == DwgObject.class) return obj;
            this.readSpecificObject(obj, data, bitPos);
            return obj;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return obj;
        }
        catch (CorruptedDwgEntityException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void readSpecificObject(DwgObject obj, int[] data, int bitPos) throws RuntimeException, CorruptedDwgEntityException {
        DwgObjectReaderPool pool = DwgObjectReaderPool.getInstance();
        IDwgObjectReader reader = pool.get(obj, "15");
        if (reader != null) {
            reader.setFileReader(this);
            reader.readSpecificObj(data, bitPos, obj);
        } else {
            logger.warn("No se ha implementado la lectura de " + obj.getClass().getName() + ", code=" + obj.getType());
        }
    }

    protected void readHeaders() {
        int offset = this.dwgFile.getDwgSectionOffset("HEADERS");
        this.bb.position(offset);
        this.bb.order(ByteOrder.nativeOrder());
        byte[] sentinel = new byte[16];
        this.bb.get(sentinel);
        if (sentinel[0] != 207) {
            logger.warn("sentinel[0] != 0xcf");
        }
        if (sentinel[1] != 123) {
            logger.warn("sentinel[1] != 0x7b");
        }
        if (sentinel[2] != 31) {
            logger.warn("sentinel[2] != 0x1f");
        }
        if (sentinel[3] != 35) {
            logger.warn("sentinel[3] != 0x23");
        }
        if (sentinel[4] != 253) {
            logger.warn("sentinel[4] != 0xfd");
        }
        if (sentinel[5] != 222) {
            logger.warn("sentinel[5] != 0xde");
        }
        if (sentinel[6] != 56) {
            logger.warn("sentinel[6] != 0x38");
        }
        if (sentinel[7] != 169) {
            logger.warn("sentinel[7] != 0xa9");
        }
        if (sentinel[8] != 95) {
            logger.warn("sentinel[8] != 0x5f");
        }
        if (sentinel[9] != 124) {
            logger.warn("sentinel[9] != 0x7c");
        }
        if (sentinel[10] != 104) {
            logger.warn("sentinel[10] != 0x68");
        }
        if (sentinel[11] != 184) {
            logger.warn("sentinel[11] != 0xb8");
        }
        if (sentinel[12] != 78) {
            logger.warn("sentinel[12] != 0x4e");
        }
        if (sentinel[13] != 109) {
            logger.warn("sentinel[13] != 0x6d");
        }
        if (sentinel[14] != 51) {
            logger.warn("sentinel[14] != 0x33");
        }
        if (sentinel[15] != 95) {
            logger.warn("sentinel[15] != 0x5f");
        }
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = this.bb.getInt();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] data = new byte[size];
        this.bb.get(data);
        int[] intData = DwgUtil.toIntArray(data);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short crc = this.bb.getShort();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] lastSentinnel = new byte[16];
        this.bb.get(lastSentinnel);
        if (lastSentinnel[0] != 48) {
            logger.warn("lastSentinnel[0] != 0x30");
        }
        if (lastSentinnel[1] != 132) {
            logger.warn("lastSentinnel[1] != 0x84");
        }
        if (lastSentinnel[2] != 224) {
            logger.warn("lastSentinnel[2] != 0xe0");
        }
        if (lastSentinnel[3] != 220) {
            logger.warn("lastSentinnel[3] != 0xdc");
        }
        if (lastSentinnel[4] != 2) {
            logger.warn("lastSentinnel[4] != 0x02");
        }
        if (lastSentinnel[5] != 33) {
            logger.warn("lastSentinnel[5] != 0x21");
        }
        if (lastSentinnel[6] != 199) {
            logger.warn("lastSentinnel[6] != 0xc7");
        }
        if (lastSentinnel[7] != 86) {
            logger.warn("lastSentinnel[7] != 0x56");
        }
        if (lastSentinnel[8] != 160) {
            logger.warn("lastSentinnel[8] != 0xa0");
        }
        if (lastSentinnel[9] != 131) {
            logger.warn("lastSentinnel[9] != 0x83");
        }
        if (lastSentinnel[10] != 151) {
            logger.warn("lastSentinnel[10] != 0x97");
        }
        if (lastSentinnel[11] != 71) {
            logger.warn("lastSentinnel[11] != 0x47");
        }
        if (lastSentinnel[12] != 177) {
            logger.warn("lastSentinnel[12] != 0xb1");
        }
        if (lastSentinnel[13] != 146) {
            logger.warn("lastSentinnel[13] != 0x92");
        }
        if (lastSentinnel[14] != 204) {
            logger.warn("lastSentinnel[14] != 0xcc");
        }
        if (lastSentinnel[15] != 160) {
            logger.warn("lastSentinnel[15] != 0xa0");
        }
        int bitPos = 0;
        try {
            ArrayList val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL1", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL2", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL3", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL4", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING1", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING2", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING3", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING4", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LONG1", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LONG2", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("HANDLE1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMASO", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSHO", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLINEGEN", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ORTHOMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("REGENMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FILLMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("QTEXTMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSLTSCALE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LIMCHECK", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USER_TIMER", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SKPOLY", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ANGDIR", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLFRAME", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MIRRTEXT", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("WORLDVIEW", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TILEMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLIMCHECK", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VISRETAIN", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DISPSILH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PELLISE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PROXYGRAPH", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TREEDEPTH", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LUPREC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("AUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("AUPREC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ATTMODE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PDMODE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI1", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI3", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI4", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI5", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLINESEGS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFU", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFV", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTYPE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTAB1", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTAB2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLINETYPE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SHADEDGE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SHADEDIF", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNITMODE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MAXACTVP", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ISOLINES", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CMLJUST", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TEXTQLTY", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LTSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TEXTSIZE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TRACEWID", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SKETCHINC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FILLETRAD", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("THICKNESS", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ANGBASE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PDSIZE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLINEWID", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR1", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR2", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR3", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR4", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR5", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERA", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERB", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERD", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FACETRES", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CMLSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CELTSCALE", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MENUNAME", val.get(1));
            int[] tdcreate = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdcreate[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdcreate[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDCREATE", tdcreate);
            int[] tdupdate = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdupdate[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdupdate[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDUPDATE", tdupdate);
            int[] tdindwg = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdindwg[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdindwg[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDINDWG", tdindwg);
            int[] tdusrtime = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdusrtime[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdusrtime[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDUSRTIME", tdusrtime);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CECOLOR", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("HANDSEED", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CLAYER", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("TEXSTYLE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CELLTYPE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMSTYLE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CMLSTYLE", new Integer(intHandle));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSVPSCALE", val.get(1));
            double[] spaces1 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_INSBASE", spaces1);
            double[] spaces2 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_EXTMIN", spaces2);
            double[] spaces3 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_EXTMAX", spaces2);
            double[] spaces4 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces4[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces4[1] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_LIMMIN", spaces4);
            double[] spaces5 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces5[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces5[1] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_LIMMAX", spaces5);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSPACE_ELEVATION", val.get(1));
            double[] spaces6 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSORG", spaces6);
            double[] spaces7 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSXDIR", spaces7);
            double[] spaces8 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSYDIR", spaces8);
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PSPACE_UCSNAME", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PUCSBASE", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PUCSORTHOVIEW", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PUCSORTHOREF", new Integer(intHandle));
            double[] pucsorgtop = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGTOP", pucsorgtop);
            double[] pucsorgbottom = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGBOTTOM", pucsorgbottom);
            double[] pucsorgleft = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGLEFT", pucsorgleft);
            double[] pucsorgright = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGRIGHT", pucsorgright);
            double[] pucsorgfront = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGFRONT", pucsorgfront);
            double[] pucsorgback = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGBACK", pucsorgback);
            double[] spaces9 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_INSBASE", spaces9);
            double[] spaces10 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_EXTMIN", spaces10);
            double[] spaces11 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_EXTMAX", spaces11);
            double[] spaces12 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces12[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces12[1] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_LIMMIN", spaces12);
            double[] spaces13 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces13[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces13[1] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_LIMMAX", spaces13);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MSPACE_ELEVATION", (Double)val.get(1));
            double[] spaces14 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSORG", spaces14);
            double[] spaces15 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSXDIR", spaces15);
            double[] spaces16 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSYDIR", spaces16);
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("MSPACE_UCSNAME", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCSBASE", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UCSORTHOVIEW", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCSORTHOREF", new Integer(intHandle));
            double[] ucsorgtop = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGTOP", ucsorgtop);
            double[] ucsorgbottom = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGBOTTOM", ucsorgbottom);
            double[] ucsorgleft = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGLEFT", ucsorgleft);
            double[] ucsorgright = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGRIGHT", ucsorgright);
            double[] ucsorgfront = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGFRONT", ucsorgfront);
            double[] ucsorgback = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGBACK", ucsorgback);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMPOST", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAPOST", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMASZ", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMEXO", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDLI", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMEXE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAND", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDLE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTM", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOL", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLIM", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTIH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSE1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSE2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTAD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMZIN", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAZIN", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTXT", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCEN", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSZ", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTF", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLFAC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTVP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTFAC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMGAP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTRND", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTD", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOFL", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSAH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTIX", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSOXD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMADEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTDEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTU", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTTD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAUNIT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMFRAC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLUNIT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDSEP", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTMOVE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMJUST", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSD1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSD2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOLJ", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTZIN", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTZ", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTTZ", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMUPT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMFIT", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMTXTSTY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMLDRBLK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK1", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK2", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLWD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLWE", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("BLOCK_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LAYER_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("STYLE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LINETYPE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("VIEW_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCS_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("VPORT_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("APPID_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMSTYLE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("VIEWPORT_ENTITY_HEADER", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("ACAD_GROUP_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("ACAD_MLINE_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("NAMED_OBJECT_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("HYPERLINKBASE", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STYLESHEET", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LAYOUT_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PLOT_SETTINGS_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PLOT_STYLES_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FLAGS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("INSUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CEPSNTYPE", val.get(1));
            if ((Integer)val.get(1) == 3) {
                val = DwgUtil.getHandle(intData, bitPos);
                bitPos = (Integer)val.get(0);
                intHandle = DwgUtil.handleToInt(val);
                this.dwgFile.setHeader("CPSNID", new Integer(intHandle));
            }
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FINGERPRINTGUID", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VERSIONGUID", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PAPER_BLOCK_RECORD", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("MODEL_BLOCK_RECORD", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_BYLAYER", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_BYBLOCK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_CONTINUOUS", new Integer(intHandle));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

