/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v1314;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgDictionary;
import org.gvsig.dwg.lib.readers.v1314.AbstractDwg1314Reader;

public class DwgDictionaryReader1314
extends AbstractDwg1314Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        int i;
        if (!(dwgObj instanceof DwgDictionary)) {
            throw new RuntimeException("ArcReader 15 solo puede leer DwgDictionary");
        }
        DwgDictionary dic = (DwgDictionary)dwgObj;
        int bitPos = offset;
        ArrayList val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int nr = (Integer)val.get(1);
        val = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)val.get(0);
        int ni = (Integer)val.get(1);
        int u = 0;
        if (dic.getVersion() == "Autocad R14") {
            val = DwgUtil.getRawChar(data, bitPos);
            bitPos = (Integer)val.get(0);
            u = (Integer)val.get(1);
        }
        String[] texts = null;
        if (ni > 0) {
            texts = new String[ni];
            for (int i2 = 0; i2 < ni; ++i2) {
                val = DwgUtil.getTextString(data, bitPos);
                bitPos = (Integer)val.get(0);
                texts[i2] = (String)val.get(1);
            }
        }
        DwgHandleReference handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        dic.setParentHandle(handle);
        for (i = 0; i < nr; ++i) {
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            dic.addReactorHandle(handle);
        }
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        dic.setXDicObjHandle(handle);
        if (ni > 0) {
            for (i = 0; i < ni; ++i) {
                handle = new DwgHandleReference();
                bitPos = handle.read(data, bitPos);
                dic.put(texts[i], handle);
            }
        }
    }
}

