/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v1314;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgLwPolyline;
import org.gvsig.dwg.lib.readers.v1314.AbstractDwg1314Reader;

public class DwgLwPolylineReader1314
extends AbstractDwg1314Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        int i;
        if (!(dwgObj instanceof DwgLwPolyline)) {
            throw new RuntimeException("ArcReader 14 solo puede leer DwgLwPolyline");
        }
        DwgLwPolyline l = (DwgLwPolyline)dwgObj;
        int bitPos = offset;
        bitPos = this.headTailReader.readObjectHeader(data, bitPos, l);
        ArrayList val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int flag = (Integer)val.get(1);
        l.setFlag(flag);
        double dVal = 0.0;
        if ((flag & 4) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            dVal = (Double)val.get(1);
        }
        l.setConstWidth(dVal);
        dVal = 0.0;
        if ((flag & 8) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            dVal = (Double)val.get(1);
        }
        l.setElevation(dVal);
        dVal = 0.0;
        if ((flag & 2) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            dVal = (Double)val.get(1);
        }
        l.setThickness(dVal);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if ((flag & 1) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            x = (Double)val.get(1);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            y = (Double)val.get(1);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            z = (Double)val.get(1);
        }
        l.setNormal(new double[]{x, y, z});
        val = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)val.get(0);
        int np = (Integer)val.get(1);
        int nb = 0;
        if ((flag & 0x10) > 0) {
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            nb = (Integer)val.get(1);
        }
        if (nb > 10000) {
            throw new CorruptedDwgEntityException("LwPolyline corrupta");
        }
        int nw = 0;
        if ((flag & 0x20) > 0) {
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            nw = (Integer)val.get(1);
        }
        if (nw > 10000) {
            throw new CorruptedDwgEntityException("LwPolyline corrupta");
        }
        if (np > 0) {
            if (np > 10000) {
                throw new CorruptedDwgEntityException("LwPolyline corrupta");
            }
            ArrayList<double[]> points = new ArrayList<double[]>();
            for (i = 0; i < np; ++i) {
                val = DwgUtil.getRawDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                x = (Double)val.get(1);
                val = DwgUtil.getRawDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                y = (Double)val.get(1);
                points.add(new double[]{x, y});
            }
            l.setVertices(points);
        }
        if (nb > 0) {
            double[] bulges = new double[nb];
            for (i = 0; i < nb; ++i) {
                val = DwgUtil.getRawDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                bulges[i] = (Double)val.get(1);
            }
            l.setBulges(bulges);
        }
        if (nw > 0) {
            double[][] widths = new double[nw][2];
            for (i = 0; i < nw; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double sw = (Double)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double ew = (Double)val.get(1);
                widths[i][0] = sw;
                widths[i][1] = ew;
            }
            l.setWidths(widths);
        }
        bitPos = this.headTailReader.readObjectTailer(data, bitPos, l);
    }
}

