/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v15;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgLwPolyline;
import org.gvsig.dwg.lib.readers.v15.AbstractDwg15Reader;

public class DwgLwPolylineReader15
extends AbstractDwg15Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        int i;
        double[] bulges;
        if (!(dwgObj instanceof DwgLwPolyline)) {
            throw new RuntimeException("ArcReader 15 solo puede leer DwgLwPolyLine");
        }
        DwgLwPolyline line = (DwgLwPolyline)dwgObj;
        ArrayList val = null;
        int bitPos = offset;
        bitPos = this.headTailReader.readObjectHeader(data, bitPos, dwgObj);
        val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int flag = (Integer)val.get(1);
        line.setFlag(flag);
        double constWidth = 0.0;
        if ((flag & 4) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            constWidth = (Double)val.get(1);
        }
        line.setConstWidth(constWidth);
        double elev = 0.0;
        if ((flag & 8) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            elev = (Double)val.get(1);
        }
        line.setElevation(elev);
        double thickness = 0.0;
        if ((flag & 2) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            thickness = (Double)val.get(1);
        }
        line.setThickness(thickness);
        double nx = 0.0;
        double ny = 0.0;
        double nz = 0.0;
        if ((flag & 1) > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            nx = (Double)val.get(1);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            ny = (Double)val.get(1);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            nz = (Double)val.get(1);
        }
        line.setNormal(new double[]{nx, ny, nz});
        val = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)val.get(0);
        int numberOfPoints = (Integer)val.get(1);
        int numberOfBulges = 0;
        if ((flag & 0x10) > 0) {
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            numberOfBulges = (Integer)val.get(1);
        }
        int numberOfWidths = 0;
        if ((flag & 0x20) > 0) {
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            numberOfWidths = (Integer)val.get(1);
        }
        if (numberOfPoints > 0) {
            if (numberOfPoints > 10000) {
                throw new CorruptedDwgEntityException("LwPolyline corrupta");
            }
            ArrayList<double[]> vertices = new ArrayList<double[]>();
            val = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double x0 = (Double)val.get(1);
            val = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double y0 = (Double)val.get(1);
            vertices.add(new double[]{x0, y0});
            for (int i2 = 1; i2 < numberOfPoints; ++i2) {
                val = DwgUtil.getDefaultDouble(data, bitPos, x0);
                bitPos = (Integer)val.get(0);
                double x = (Double)val.get(1);
                val = DwgUtil.getDefaultDouble(data, bitPos, y0);
                bitPos = (Integer)val.get(0);
                double y = (Double)val.get(1);
                vertices.add(new double[]{x, y});
                x0 = x;
                y0 = y;
            }
            line.setVertices(vertices);
        } else {
            System.out.println("vertices == 0: lanzamos una excepcion??");
        }
        if (numberOfBulges > 0) {
            if (numberOfBulges != numberOfPoints) {
                System.out.println("bulges != vertices: lanzamos una excepcion??");
            }
            bulges = new double[numberOfBulges];
            for (i = 0; i < numberOfBulges; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                bulges[i] = (Double)val.get(1);
            }
            line.setBulges(bulges);
        } else {
            bulges = new double[numberOfPoints];
            for (i = 0; i < numberOfPoints; ++i) {
                bulges[i] = 0.0;
            }
            line.setBulges(bulges);
        }
        if (numberOfWidths > 0) {
            if (numberOfWidths != numberOfPoints) {
                System.out.println("widths != vertices: lanzamos una excepcion??");
            }
            double[][] widths = new double[numberOfWidths][2];
            for (i = 0; i < numberOfWidths; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double sw = (Double)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double ew = (Double)val.get(1);
                widths[i][0] = sw;
                widths[i][1] = ew;
            }
            line.setWidths(widths);
        } else {
            line.setWidths(new double[0][0]);
        }
        bitPos = this.headTailReader.readObjectTailer(data, bitPos, line);
    }
}

