/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.util;

import java.awt.geom.Point2D;
import java.util.List;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Surface;

public class FMapUtil {
    private static final GeometryManager gManager = GeometryLocator.getGeometryManager();

    public static Line ptsToLine(List<double[]> pts, int subType) throws CreateGeometryException {
        if (pts.size() < 2) {
            throw new IllegalArgumentException();
        }
        boolean is3D = subType == 1 || subType == 3;
        Line line = gManager.createLine(subType);
        for (double[] p : pts) {
            if (is3D) {
                if (p.length < 3) {
                    line.addVertex(p[0], p[1], 0.0);
                    continue;
                }
                line.addVertex(p[0], p[1], p[2]);
                continue;
            }
            line.addVertex(p[0], p[1]);
        }
        return line;
    }

    public static Surface ptsToPolygon(List<double[]> pts, int subType) throws CreateGeometryException {
        if (pts.size() < 3) {
            throw new IllegalArgumentException();
        }
        boolean is3D = subType == 1 || subType == 3;
        Polygon polygon = gManager.createPolygon(subType);
        for (double[] p : pts) {
            if (is3D) {
                polygon.addVertex(p[0], p[1], p[2]);
                continue;
            }
            polygon.addVertex(p[0], p[1]);
        }
        return polygon;
    }

    public static Point createPoint(int subType, double[] point) throws CreateGeometryException {
        Point result = gManager.createPoint(point[0], point[1], subType);
        if (subType == 1) {
            result.setCoordinateAt(2, point[2]);
        }
        return result;
    }

    public static Point createPoint(int subType, Point2D point) throws CreateGeometryException {
        Point result = gManager.createPoint(point.getX(), point.getY(), subType);
        return result;
    }

    public static Point createPoint(int subType, IDwgVertex dwgvertex) throws CreateGeometryException {
        double[] point = dwgvertex.getPoint();
        Point result = gManager.createPoint(point[0], point[1], subType);
        if (subType == 1) {
            result.setCoordinateAt(2, point[2]);
        }
        return result;
    }

    public static double angleDistance(double angle1, double angle2) {
        if (angle1 < angle2) {
            return angle2 - angle1;
        }
        return Math.PI * 2 - angle1 + angle2;
    }
}

