/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gvsig.dwg.lib.util.ArcFromBulgeCalculator;

public class GisModelCurveCalculator {
    public static List calculateGisModelCircle(Point2D c, double r) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        int angulo = 0;
        for (angulo = 0; angulo < 360; ++angulo) {
            double[] pt = new double[]{c.getX(), c.getY()};
            pt[0] = pt[0] + r * Math.sin((double)angulo * Math.PI / 180.0);
            pt[1] = pt[1] + r * Math.cos((double)angulo * Math.PI / 180.0);
            pts.add(pt);
        }
        return pts;
    }

    public static List calculateGisModelEllipse(Point2D center, Point2D majorAxisVector, double axisRatio, double initAngle, double endAngle) {
        Point2D.Double majorPoint = new Point2D.Double(center.getX() + majorAxisVector.getX(), center.getY() + majorAxisVector.getY());
        double orientation = Math.atan(majorAxisVector.getY() / majorAxisVector.getX());
        double semiMajorAxisLength = center.distance(majorPoint);
        double semiMinorAxisLength = semiMajorAxisLength * axisRatio;
        double eccentricity = Math.sqrt(1.0 - Math.pow(semiMinorAxisLength, 2.0) / Math.pow(semiMajorAxisLength, 2.0));
        int isa = (int)initAngle;
        int iea = (int)endAngle;
        ArrayList<double[]> pts = new ArrayList<double[]>();
        if (initAngle <= endAngle) {
            double angulo = initAngle;
            double r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            double x = r * Math.cos(angulo * Math.PI / 180.0);
            double y = r * Math.sin(angulo * Math.PI / 180.0);
            double xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            double yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            double[] pt = new double[]{center.getX() + xrot, center.getY() + yrot};
            pts.add(pt);
            for (int i = 1; i <= iea - isa + 1; ++i) {
                angulo = isa + i;
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pt = new double[]{center.getX() + xrot, center.getY() + yrot};
                pts.add(pt);
            }
            angulo = endAngle;
            r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            x = r * Math.cos(angulo * Math.PI / 180.0);
            y = r * Math.sin(angulo * Math.PI / 180.0);
            xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pt = new double[]{center.getX() + xrot, center.getY() + yrot};
            pts.add(pt);
        } else {
            int i;
            double angulo = initAngle;
            double r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            double x = r * Math.cos(angulo * Math.PI / 180.0);
            double y = r * Math.sin(angulo * Math.PI / 180.0);
            double xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            double yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            double[] pt = new double[]{center.getX() + r * Math.cos(angulo * Math.PI / 180.0), center.getY() + r * Math.sin(angulo * Math.PI / 180.0)};
            pts.add(pt);
            for (i = 1; i <= 360 - isa; ++i) {
                angulo = isa + i;
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pt = new double[]{center.getX() + xrot, center.getY() + yrot};
                pts.add(pt);
            }
            for (i = 360 - isa + 1; i <= 360 - isa + iea; ++i) {
                angulo = i - (360 - isa);
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pt = new double[]{center.getX() + xrot, center.getY() + yrot};
                pts.add(pt);
            }
            angulo = endAngle;
            r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            x = r * Math.cos(angulo * Math.PI / 180.0);
            y = r * Math.sin(angulo * Math.PI / 180.0);
            xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pt = new double[]{center.getX() + xrot, center.getY() + yrot};
            pts.add(pt);
        }
        return pts;
    }

    public static List calculateGisModelArc(double[] center, double r, double sa, double ea) {
        int isa = (int)sa;
        int iea = (int)ea;
        ArrayList<double[]> pts = new ArrayList<double[]>();
        if (sa <= ea) {
            double angulo = sa;
            pts.add(new double[]{center[0] + r * Math.cos(angulo * Math.PI / 180.0), center[1] + r * Math.sin(angulo * Math.PI / 180.0)});
            for (int i = 1; i <= iea - isa + 1; ++i) {
                angulo = isa + i;
                double x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
                double y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
                pts.add(new double[]{x, y});
            }
            angulo = ea;
            double x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
            double y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
            pts.add(new double[]{x, y});
        } else {
            int i;
            double angulo = sa;
            double x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
            double y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
            pts.add(new double[]{x, y});
            for (i = 1; i <= 360 - isa; ++i) {
                angulo = isa + i;
                x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
                y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
                pts.add(new double[]{x, y});
            }
            for (i = 360 - isa + 1; i <= 360 - isa + iea; ++i) {
                angulo = i - (360 - isa);
                x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
                y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
                pts.add(new double[]{x, y});
            }
            angulo = ea;
            x = center[0] + r * Math.cos(angulo * Math.PI / 180.0);
            y = center[1] + r * Math.sin(angulo * Math.PI / 180.0);
            pts.add(new double[]{x, y});
        }
        return pts;
    }

    public static List calculateGisModelBulge(List newPts, double[] bulges) {
        Vector<Object> ptspol = new Vector<Object>();
        double[] init = null;
        double[] end = null;
        for (int j = 0; j < newPts.size(); ++j) {
            int k;
            init = (double[])newPts.get(j);
            if (j != newPts.size() - 1) {
                end = (double[])newPts.get(j + 1);
            }
            if (bulges[j] == 0.0 || j == newPts.size() - 1 || init[0] == end[0] && init[1] == end[1]) {
                ptspol.add(init);
                continue;
            }
            ArcFromBulgeCalculator arcCalculator = new ArcFromBulgeCalculator(init, end, bulges[j]);
            Vector arc = arcCalculator.getPoints(1.0);
            if (bulges[j] < 0.0) {
                for (k = arc.size() - 1; k >= 0; --k) {
                    ptspol.add(arc.get(k));
                }
                ptspol.remove(ptspol.size() - 1);
                continue;
            }
            for (k = 0; k < arc.size(); ++k) {
                ptspol.add(arc.get(k));
            }
            ptspol.remove(ptspol.size() - 1);
        }
        ArrayList points = new ArrayList();
        for (int j = 0; j < ptspol.size(); ++j) {
            points.add(ptspol.get(j));
        }
        return points;
    }
}

