/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.gui;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.gui.ConnectDialog;
import org.gvsig.catalog.gui.ShowResultsDialog;
import org.gvsig.catalog.querys.Coordinates;
import org.gvsig.catalog.ui.search.SearchDialogPanel;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class SearchDialog
extends SearchDialogPanel
implements ViewPortListener {
    public ConnectDialog parentDialog = null;

    public SearchDialog(CatalogClient client, Object serverConnectFrame) {
        super(client, serverConnectFrame);
        this.parentDialog = (ConnectDialog)((Object)serverConnectFrame);
        this.setViewChangeListener();
        this.loadViewPortCoordinates();
        this.setPreferredSize(new Dimension(525, 180));
    }

    protected void showResultsActionPerformed(GetRecordsReply recordsReply) {
        WindowManager windowManager = ToolsSwingLocator.getWindowManager();
        ShowResultsDialog dialog = new ShowResultsDialog(this.client, recordsReply, 1);
        windowManager.showWindow((JComponent)((Object)dialog), ToolsSwingUtils.makeTitle((String)"search_results", (String)this.parentDialog.getCurrentServer(), null), WindowManager.MODE.TOOL);
    }

    protected void closeButtonActionPerformed() {
        this.closeJDialog();
    }

    protected Icon getUpIcon() {
        return IconThemeHelper.getImageIcon((String)"catalog-move-up");
    }

    protected Icon getDownIcon() {
        return IconThemeHelper.getImageIcon((String)"catalog-move-down");
    }

    protected void lastButtonActionPerformed() {
        this.closeJDialog();
        ConnectDialog serverConnect = (ConnectDialog)((Object)this.serverConnectFrame);
        serverConnect.setVisible(true);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        windowManager.showWindow((JComponent)((Object)serverConnect), Messages.getText((String)"metadata_catalog"), WindowManager.MODE.TOOL, Collections.singletonMap("align", 23));
    }

    public void closeJDialog() {
        this.setVisible(false);
    }

    private void loadViewPortCoordinates() {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel activeView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        Rectangle2D r2d = activeView.getMapControl().getViewPort().getExtent();
        try {
            this.getLowerPanel().setCoordinates(new Coordinates(r2d.getMinX(), r2d.getMaxY(), r2d.getMaxX(), r2d.getMinY()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setViewChangeListener() {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel activeView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        activeView.getMapControl().getViewPort().addViewPortListener((ViewPortListener)this);
    }

    public void extentChanged(ExtentEvent e) {
        this.loadViewPortCoordinates();
    }

    public void backColorChanged(ColorEvent e) {
    }

    public void projectionChanged(ProjectionEvent e) {
        this.loadViewPortCoordinates();
    }
}

