/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.gvsig.catalog.loaders.GvSigLayerLoader;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.utils.Strings;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.i18n.Messages;

public class PostgisLayerLoader
extends GvSigLayerLoader {
    public PostgisLayerLoader(Resource resource) {
        super(resource);
    }

    @Override
    protected boolean hasSpecificLayer() {
        return false;
    }

    @Override
    protected String getLayerName() {
        return this.getResource().getName();
    }

    @Override
    protected DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        String jdbcUrl = this.getResource().getLinkage();
        String table = this.getResource().getName();
        DataStoreParameters dataStoreParameters = DATA_MANAGER.createStoreParameters("PostgreSQL");
        this.parseParams(dataStoreParameters, jdbcUrl, table);
        return dataStoreParameters;
    }

    private void parseParams(DataStoreParameters dataStoreParameters, String jdbcUrl, String table) {
        StringTokenizer sti = new StringTokenizer(jdbcUrl, "?");
        String dbURL = sti.nextToken();
        String user = "";
        String pwd = "";
        if (sti.hasMoreTokens()) {
            String p = sti.nextToken();
            TreeMap map = this.separateParams(p);
            user = (String)map.get("USER");
            pwd = (String)map.get("PASSWORD");
            map = Strings.separateParams((String)table);
            dataStoreParameters.setDynValue("USER", (Object)user);
            dataStoreParameters.setDynValue("PASSWORD", (Object)pwd);
            dataStoreParameters.setDynValue("WHERECLAUSE", (Object)"");
            dataStoreParameters.setDynValue("DBURL", (Object)dbURL);
        } else if (dbURL.startsWith("jdbc:postgresql://")) {
            try {
                URL url = new URL(dbURL.replace("jdbc:postgresql://", "http://"));
                if (url != null) {
                    dataStoreParameters.setDynValue("host", (Object)url.getHost());
                    dataStoreParameters.setDynValue("port", (Object)(url.getPort() + ""));
                    String path = url.getPath();
                    user = path.substring(1, path.indexOf(":"));
                    pwd = this.getCredentials(user);
                    String db = path.substring(path.indexOf("@") + 1);
                    dataStoreParameters.setDynValue("dbuser", (Object)user);
                    dataStoreParameters.setDynValue("password", (Object)pwd);
                    dataStoreParameters.setDynValue("dbname", (Object)db);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        dataStoreParameters.setDynValue("Table", (Object)table);
    }

    private String getCredentials(String user) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Messages.getText((String)"password_needed") + " (" + user + "):");
        JPasswordField pass = new JPasswordField();
        pass.setPreferredSize(new Dimension(150, 25));
        panel.add(label);
        panel.add(pass);
        Object[] options = new String[]{Messages.getText((String)"connectButton"), Messages.getText((String)"cancelSearchButton")};
        int option = JOptionPane.showOptionDialog(null, panel, Messages.getText((String)"password_needed_title"), 1, -1, null, options, options[1]);
        if (option == 0) {
            return new String(pass.getPassword());
        }
        return "";
    }

    private TreeMap separateParams(String pairValues) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] params = pairValues.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] nameValue = params[i].split("=");
            map.put(nameValue[0].toUpperCase(), nameValue[1]);
        }
        return map;
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"postgisError") + ".\n" + Messages.getText((String)"server") + ": " + this.getResource().getLinkage() + "\n" + Messages.getText((String)"parameters") + ": " + this.getResource().getName();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"postgisLoad");
    }
}

