/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.loaders.GvSigLayerLoader;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.i18n.Messages;

public class WMSLayerLoader
extends GvSigLayerLoader {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SRSSTR = "srsstr";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_TRANSPARENCY = "transparency";
    private static final String FIELD_LAYERQUERY = "layer_query";
    private static final String FIELD_URI = "uri";
    private static final String FIELD_ONLINERESOURC = "onlineresources";
    private static final String FIELD_DELETECACHE = "deletecache";

    public WMSLayerLoader(Resource resource) {
        super(resource);
    }

    @Override
    protected boolean hasSpecificLayer() {
        return true;
    }

    @Override
    protected String getLayerName() {
        return this.getResource().getName();
    }

    @Override
    protected DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        DataStoreParameters dataStoreParameters = DATA_MANAGER.createStoreParameters("Wms Store");
        dataStoreParameters.setDynValue(FIELD_URI, (Object)this.getResource().getLinkage());
        dataStoreParameters.setDynValue(FIELD_FORMAT, (Object)"image/png");
        dataStoreParameters.setDynValue(FIELD_LAYERQUERY, (Object)this.getResource().getName());
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel activeView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        dataStoreParameters.setDynValue(FIELD_SRSSTR, (Object)activeView.getProjection().getAbrev());
        dataStoreParameters.setDynValue(FIELD_TRANSPARENCY, (Object)Boolean.TRUE);
        dataStoreParameters.setDynValue(FIELD_NAME, (Object)this.getLayerName());
        dataStoreParameters.setDynValue(FIELD_ONLINERESOURC, (Object)this.createOnlineResources());
        dataStoreParameters.setDynValue(FIELD_DELETECACHE, (Object)true);
        return dataStoreParameters;
    }

    protected Map createOnlineResources() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("GepMap", this.getResource().getLinkage());
        return args;
    }

    @Override
    protected String extensionPointName() {
        return "OGC:WMS";
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"wmsError") + ".\n" + Messages.getText((String)"server") + ": " + this.getResource().getLinkage() + "\n" + Messages.getText((String)"layer") + ": " + this.getResource().getName();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"loadWMS");
    }
}

