/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.app.mainplugin;

import java.util.ArrayList;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;

public class ServiceExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        IView view = this.getActiveView();
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        if (view != null) {
            EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
            editingContext.activateService(actionCommand);
        }
    }

    public boolean isEnabled() {
        IView view = this.getActiveView();
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        if (view != null) {
            EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
            return !editingContext.isProcessing();
        }
        return this.isVisible();
    }

    public boolean isEnabled(String action) {
        FLyrVect activeLayer;
        IView view = this.getActiveView();
        if (view != null && (activeLayer = this.getActiveEditingVectLayer(view)) != null && activeLayer.isEditing() && action != null) {
            EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
            EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
            if (editingContext.isProcessing()) {
                return false;
            }
            return editingContext.isServiceCompatible(action);
        }
        return false;
    }

    public boolean isVisible() {
        IView view = this.getActiveView();
        if (view != null) {
            FLyrVect activeLayer = this.getActiveEditingVectLayer(view);
            return activeLayer != null && activeLayer.isEditing();
        }
        return false;
    }

    public boolean isVisible(String action) {
        return this.isVisible();
    }

    public boolean canQueryByAction() {
        return true;
    }

    private IView getActiveView() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        return view;
    }

    private FLyrVect getActiveEditingVectLayer(IView view) {
        ArrayList<FLyrVect> activeEditingVectLayers = new ArrayList<FLyrVect>();
        if (view != null) {
            FLayer[] activeLayers;
            ViewDocument viewDocument = view.getViewDocument();
            for (FLayer activeLayer : activeLayers = viewDocument.getMapContext().getLayers().getActives()) {
                FLyrVect activeVectLayer;
                if (!(activeLayer instanceof FLyrVect) || !(activeVectLayer = (FLyrVect)activeLayer).isEditing()) continue;
                activeEditingVectLayers.add(activeVectLayer);
            }
            if (activeEditingVectLayers.size() == 1) {
                return (FLyrVect)activeEditingVectLayers.get(0);
            }
        }
        return null;
    }
}

