/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.Geodetic;
import org.cresques.impl.geo.Graticule;
import org.cresques.impl.geo.Mercator;
import org.cresques.impl.geo.ReProjection;
import org.cresques.impl.geo.UtmZone;
import org.gvsig.fmap.crs.CRSFactory;

public abstract class Projection
implements IProjection {
    public static int NORTH = 0;
    public static int SOUTH = 1;
    static String name = "Sin Proyeccion";
    static String abrev = "None";
    private static final Color basicGridColor = new Color(64, 64, 64, 128);
    Color gridColor = basicGridColor;
    Ellipsoid eli = Ellipsoid.hayford;
    Graticule grid;

    public Projection() {
        this.eli = Ellipsoid.hayford;
    }

    public Projection(Ellipsoid e) {
        this.eli = e;
    }

    public String getName() {
        return name;
    }

    public abstract String getAbrev();

    public IDatum getDatum() {
        return this.eli;
    }

    public double[] getElliPar() {
        return this.eli.getParam();
    }

    public abstract Point2D createPoint(double var1, double var3);

    public Point2D createPoint(Point2D pt) {
        return this.createPoint(pt.getX(), pt.getY());
    }

    public static IProjection getProjectionByName(IDatum eli, String name) {
        if (name.indexOf("UTM") >= 0) {
            return UtmZone.getProjectionByName(eli, name);
        }
        if (name.indexOf("GEO") >= 0) {
            return Geodetic.getProjectionByName(eli, name);
        }
        if (name.indexOf("MERC") >= 0) {
            return Mercator.getProjectionByName(eli, name);
        }
        return null;
    }

    public ReProjection getReproyectionTo(Projection proj) {
        ReProjection rp = new ReProjection(this, proj);
        return rp;
    }

    public abstract Point2D toGeo(Point2D var1);

    public abstract Point2D fromGeo(Point2D var1, Point2D var2);

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public static String coordToString(double coord, String fmt, boolean isLat) {
        String txt = fmt;
        int donde = txt.indexOf("%G");
        if (donde >= 0) {
            int deg = (int)coord;
            if (fmt.indexOf("%N") >= 0 && deg < 0) {
                deg = -deg;
            }
            txt = txt.substring(0, donde) + Integer.toString(deg) + txt.substring(donde + 2);
        }
        if ((donde = txt.indexOf("%M")) >= 0) {
            int min = (int)((coord - (double)((int)coord)) * 60.0) % 60;
            if (fmt.indexOf("%N") >= 0 && min < 0) {
                min = -min;
            }
            txt = txt.substring(0, donde) + Integer.toString(min) + txt.substring(donde + 2);
        }
        if ((donde = txt.indexOf("%N")) >= 0) {
            String t = "";
            if (isLat) {
                if (coord > 0.0) {
                    t = "N";
                } else if (coord < 0.0) {
                    t = "S";
                }
            } else if (coord > 0.0) {
                t = "E";
            } else if (coord < 0.0) {
                t = "W";
            }
            txt = txt.substring(0, donde) + t + txt.substring(donde + 2);
        }
        return txt;
    }

    public abstract void drawGrid(Graphics2D var1, ViewPortData var2);

    public boolean isProjected() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return CRSFactory.getCRS((String)this.getFullCode());
    }

    public String export(String format) {
        return null;
    }
}

