/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import geojava.GeoUtm;
import geojava.Ra2De;
import geojava.UtmGeo;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.GeoPoint;
import org.cresques.impl.geo.Geodetic;
import org.cresques.impl.geo.Graticule;
import org.cresques.impl.geo.Projection;
import org.cresques.impl.geo.UtmPoint;
import org.cresques.px.Extent;

public class UtmZone
extends Projection {
    static String name = "UTM";
    static String abrev = "UTM";
    private static final UtmZone ed5028N = new UtmZone(Ellipsoid.ed50, 28, 0, 0.0);
    private static final UtmZone ed5029N = new UtmZone(Ellipsoid.ed50, 29, 0, 0.0);
    private static final UtmZone ed5030N = new UtmZone(Ellipsoid.ed50, 30, 0, 0.0);
    private static final UtmZone ed5031N = new UtmZone(Ellipsoid.ed50, 31, 0, 0.0);
    private static final UtmZone hayford28N = new UtmZone(Ellipsoid.hayford, 28, 0, 0.0);
    private static final UtmZone hayford29N = new UtmZone(Ellipsoid.hayford, 29, 0, 0.0);
    private static final UtmZone hayford30N = new UtmZone(Ellipsoid.hayford, 30, 0, 0.0);
    private static final UtmZone hayford31N = new UtmZone(Ellipsoid.hayford, 31, 0, 0.0);
    static GeoUtm geoutm = new GeoUtm();
    static UtmGeo utmgeo = new UtmGeo();
    public int Zone = 30;
    public int Hemisphere = 0;
    public double H = 0.0;

    public UtmZone(Ellipsoid eli, int zone, int hemisphere, double h) {
        super(eli);
        this.Zone = zone;
        this.Hemisphere = hemisphere;
        this.H = h;
        this.grid = new Graticule(this);
    }

    @Override
    public String getAbrev() {
        return abrev + this.Zone;
    }

    public static UtmZone getProjection(Ellipsoid eli, int zone, int hemisphere) {
        if (eli == Ellipsoid.hayford && hemisphere == 0) {
            switch (zone) {
                case 28: {
                    return hayford28N;
                }
                case 29: {
                    return hayford29N;
                }
                case 30: {
                    return hayford30N;
                }
                case 31: {
                    return hayford31N;
                }
            }
        } else if (eli == Ellipsoid.ed50 && hemisphere == 0) {
            switch (zone) {
                case 28: {
                    return ed5028N;
                }
                case 29: {
                    return ed5029N;
                }
                case 30: {
                    return ed5030N;
                }
                case 31: {
                    return ed5031N;
                }
            }
        }
        System.err.println("UtmZone.getProjection(): new " + zone);
        return new UtmZone(eli, zone, hemisphere, 0.0);
    }

    public static IProjection getProjectionByName(IDatum eli, String name) {
        int hemisphere = NORTH;
        if (name.indexOf("UTM") < 0) {
            return null;
        }
        if (name.substring(0, 1).compareTo("S") == 0) {
            hemisphere = SOUTH;
        }
        int zone = Integer.parseInt(name.substring(name.length() - 2));
        return UtmZone.getProjection((Ellipsoid)eli, zone, hemisphere);
    }

    @Override
    public Point2D createPoint(double x, double y) {
        return new UtmPoint(this, x, y);
    }

    @Override
    public Point2D toGeo(Point2D uPt) {
        GeoPoint gPt = new GeoPoint();
        return this.toGeo((UtmPoint)uPt, gPt);
    }

    public GeoPoint toGeo(UtmPoint uPt, GeoPoint gPt) {
        int[] ai = new int[3];
        double[] ad = new double[3];
        ai[1] = ((UtmZone)uPt.proj).Zone;
        ai[2] = ((UtmZone)uPt.proj).Hemisphere;
        ad[1] = uPt.X;
        ad[2] = uPt.Y;
        utmgeo.set(((Projection)uPt.proj).getElliPar(), ai, ad);
        utmgeo.go();
        gPt.Longitude = Ra2De.go((double)UtmZone.utmgeo.Ge[1]);
        gPt.Latitude = Ra2De.go((double)UtmZone.utmgeo.Ge[2]);
        gPt.proj = Geodetic.getProjection(((Projection)uPt.proj).eli);
        return gPt;
    }

    @Override
    public Point2D fromGeo(Point2D gPt, Point2D uPt) {
        int[] ai = new int[]{0, 0, 2};
        return this.fromGeo((GeoPoint)gPt, (UtmPoint)uPt, ai);
    }

    public UtmPoint fromGeo(GeoPoint gPt, UtmPoint uPt, UtmZone proj) {
        int[] ai = new int[]{0, proj.Zone, proj.Hemisphere};
        return this.fromGeo(gPt, uPt, ai);
    }

    public UtmPoint fromGeo(GeoPoint gPt, UtmPoint uPt, int[] ai) {
        double[] ad = new double[4];
        ad[1] = gPt.Longitude.ToRadians();
        ad[2] = gPt.Latitude.ToRadians();
        geoutm.set(((Projection)gPt.proj).getElliPar(), ai, ad);
        geoutm.go();
        if (UtmZone.geoutm.Ier != 0) {
            return null;
        }
        uPt.setLocation(UtmZone.geoutm.Pr[1], UtmZone.geoutm.Pr[2]);
        if (((UtmZone)uPt.proj).Zone != UtmZone.geoutm.Iopar[1] || ((UtmZone)uPt.proj).Hemisphere != UtmZone.geoutm.Iopar[2]) {
            uPt.proj = UtmZone.getProjection(((Projection)uPt.proj).eli, UtmZone.geoutm.Iopar[1], UtmZone.geoutm.Iopar[2]);
        }
        return uPt;
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat) {
        Point2D pt1 = extent.getMin();
        double step = 1.0;
        double x = (int)pt1.getX();
        double dist = 0.0;
        this.generateGrid(g, extent, mat, step);
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat, double step) {
        this.grid = new Graticule(this);
        Point2D pt1 = extent.getMin();
        Point2D pt2 = extent.getMax();
        UtmPoint up1 = (UtmPoint)this.createPoint(0.0, 0.0);
        UtmPoint up2 = (UtmPoint)this.createPoint(0.0, 0.0);
        Point2D.Double mp1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double mp2 = new Point2D.Double(0.0, 0.0);
        Geodetic geoProj = Geodetic.getProjection((Ellipsoid)this.getDatum());
        boolean esUso = false;
        System.err.println(name + ": ViewPort Extent = (" + pt1 + "," + pt2 + ")");
        GeoPoint gp1 = (GeoPoint)this.toGeo(new UtmPoint(pt1.getX(), pt2.getY()));
        GeoPoint gp2 = (GeoPoint)this.toGeo(new UtmPoint(pt2));
        double xMin = (double)((int)gp1.getX()) - 1.0;
        double xMax = (double)((int)gp2.getX()) + 1.0;
        gp1 = (GeoPoint)this.toGeo(new UtmPoint(pt1.getX() + (pt2.getX() - pt1.getX()) / 2.0, pt2.getY()));
        double yMax = (double)((int)gp1.getY()) + 2.0;
        gp1 = (GeoPoint)this.toGeo(new UtmPoint(pt1));
        double yMin = (double)((int)gp1.getY()) - 1.0;
        xMin = -30.0;
        xMax = 30.0;
        yMin = 20.0;
        yMax = 60.0;
        for (double x = xMin; x <= xMax; x += step) {
            up1 = null;
            if (Math.abs(x % 6.0) < 0.001) {
                esUso = true;
            }
            for (double y = yMin; y <= yMax; y += step) {
                gp2 = (GeoPoint)geoProj.createPoint(x, y);
                this.fromGeo(gp2, up2, this);
                if (up1 != null && (extent.isAt((Point2D)up1) || extent.isAt((Point2D)up2))) {
                    mat.transform(up2, mp2);
                    if (up1 != null) {
                        if (esUso) {
                            this.grid.addLine(mp1, mp2, 1);
                        } else {
                            this.grid.addLine(mp1, mp2);
                        }
                    }
                } else {
                    mat.transform(up2, mp2);
                }
                up1 = (UtmPoint)up2.clone();
                mp1 = (Point2D.Double)mp2.clone();
            }
            esUso = false;
        }
        for (double y = yMin; y <= yMax; y += step) {
            up1 = null;
            for (double x = xMin; x <= xMax; x += step) {
                gp2 = (GeoPoint)geoProj.createPoint(x, y);
                this.fromGeo(gp2, up2, this);
                if (up1 != null && (extent.isAt((Point2D)up1) || extent.isAt((Point2D)up2))) {
                    mat.transform(up2, mp2);
                    if (up1 != null) {
                        this.grid.addLine(mp1, mp2);
                    }
                } else {
                    mat.transform(up2, mp2);
                }
                up1 = (UtmPoint)up2.clone();
                mp1 = (Point2D.Double)mp2.clone();
            }
        }
    }

    @Override
    public void drawGrid(Graphics2D g, ViewPortData vp) {
        this.generateGrid(g, vp.getExtent(), vp.getMat());
        this.grid.setColor(this.gridColor);
        this.grid.draw(g, vp);
    }

    public double getScale(double minX, double maxX, double width, double dpi) {
        double scale = (maxX - minX) * (dpi / 2.54 * 100.0) / width;
        return scale;
    }

    public ICoordTrans getCT(IProjection dest) {
        return null;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        w = wImage / dpi * 2.54;
        h = hImage / dpi * 2.54;
        wExtent = w * scale * distanceUnits / mapUnits;
        hExtent = h * scale * distanceUnits / mapUnits;
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    public String getFullCode() {
        return this.getAbrev();
    }
}

