/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.polarmatrix;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarMatrixEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarMatrixEditingProvider.class);
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    private final EditingServiceParameter selection;
    private final EditingServiceParameter elementsNumber;
    private final EditingServiceParameter centerPoint;
    private final EditingServiceParameter elementAngle;
    private final EditingServiceParameter rotateElements;
    private List<Feature> selectedFeatures;

    public PolarMatrixEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.elementsNumber = new DefaultEditingServiceParameter("number_of_total_elements", "number_of_total_elements", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation("_yes"), (Object)true, i18nManager.getTranslation("_yes")).add(i18nManager.getTranslation("_no"), (Object)false, i18nManager.getTranslation("_no"));
        String consoleMsg = editingProviderServices.makeConsoleMessage("rotate_elements", (EditingServiceParameterOptions)options);
        this.rotateElements = new DefaultEditingServiceParameter("rotate_elements", consoleMsg, (EditingServiceParameterOptions)options, (Object)false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.centerPoint = new DefaultEditingServiceParameter("center", "center", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.elementAngle = new DefaultEditingServiceParameter("angle_between_elements", "angle_between_elements", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.elementsNumber) == null) {
            return this.elementsNumber;
        }
        if (this.values.get(this.rotateElements) == null) {
            return this.rotateElements;
        }
        if (this.values.get(this.centerPoint) == null) {
            return this.centerPoint;
        }
        if (this.values.get(this.elementAngle) == null) {
            return this.elementAngle;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Integer elementsNumberValue = (Integer)this.values.get(this.elementsNumber);
        Boolean rotateElementsValue = (Boolean)this.values.get(this.rotateElements);
        Point centerPointValue = (Point)this.values.get(this.centerPoint);
        if (CollectionUtils.isNotEmpty(this.selectedFeatures) && elementsNumberValue != null && rotateElementsValue != null && centerPointValue != null) {
            Double angle = (Double)this.values.get(this.elementAngle);
            if (angle == null) {
                angle = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)mousePosition);
                Integer elements = (Integer)this.values.get(this.elementsNumber);
                if (elements != null && angle > Math.PI * 2 / (double)(elements - 1)) {
                    angle = Math.PI * 2 / (double)(elements - 1);
                }
            }
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            try {
                LOGGER.info("centerPoint: " + centerPointValue.toString());
                drawingStatus.addStatus((Geometry)centerPointValue, auxiliaryPointSymbolEditing, "");
                int subtype = centerPointValue.getGeometryType().getSubType();
                double textDistance = 3.0 * centerPointValue.distance((Geometry)mousePosition) / 4.0;
                Point pointText = geometryManager.createPoint(centerPointValue.getX() + textDistance * Math.cos(angle / 2.0), centerPointValue.getY() + textDistance * Math.sin(angle / 2.0), subtype);
                LOGGER.info("pointText: " + pointText.toString());
                drawingStatus.addStatus((Geometry)pointText, (ISymbol)this.getTextSymbol(), this.degToDms(Math.toDegrees(angle)));
                Line horizontalLine = geometryManager.createLine(subtype);
                horizontalLine.setPoints(centerPointValue, geometryManager.createPoint(centerPointValue.getX() + centerPointValue.distance((Geometry)mousePosition), centerPointValue.getY(), subtype));
                LOGGER.info("horizontalLine: " + horizontalLine.toString());
                drawingStatus.addStatus((Geometry)horizontalLine, ruleAxisSymbol, "");
                Line verticalLine = geometryManager.createLine(subtype);
                verticalLine.setPoints(centerPointValue, mousePosition);
                LOGGER.info("verticalLine: " + verticalLine.toString());
                drawingStatus.addStatus((Geometry)verticalLine, ruleAxisSymbol, "");
                Arc arc = GeometryUtils.createArc((Point)centerPointValue, (double)(centerPointValue.distance((Geometry)mousePosition) / 2.0), (double)0.0, (double)angle, (int)subtype);
                LOGGER.info("arc: " + arc.toString());
                drawingStatus.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
            try {
                for (Feature feature : this.selectedFeatures) {
                    Geometry[] matrix;
                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                    Geometry geometry = feature.getDefaultGeometry();
                    for (Geometry element : matrix = this.createPolarMatrix(geometry, elementsNumberValue, rotateElementsValue, centerPointValue, angle)) {
                        ISymbol symbol = this.getSymbol(element);
                        if (element instanceof Aggregate) {
                            int primitivesNumber = ((Aggregate)element).getPrimitivesNumber();
                            for (int j = 0; j < primitivesNumber; ++j) {
                                drawingStatus.addStatus((Geometry)((Aggregate)element).getPrimitiveAt(j), symbol, "");
                                drawingStatus.addStatus((Geometry)((Aggregate)element).getPrimitiveAt(j), previewSymbol, "");
                            }
                            continue;
                        }
                        drawingStatus.addStatus(element, symbol, "");
                        drawingStatus.addStatus(element, previewSymbol, "");
                    }
                }
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return drawingStatus;
    }

    private ISymbol getSymbol(Geometry geometry) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        if (geometry instanceof Curve || geometry instanceof MultiCurve) {
            return lineSymbolEditing;
        }
        if (geometry instanceof Surface || geometry instanceof MultiSurface) {
            return polygonSymbolEditing;
        }
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return auxiliaryPointSymbolEditing;
        }
        return null;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    private String degToDms(double deg) {
        int m;
        int d = (int)Math.floor(deg);
        double minfloat = (deg - (double)d) * 60.0;
        double secfloat = (minfloat - (double)(m = (int)Math.floor(minfloat))) * 60.0;
        int s = (int)Math.round(secfloat);
        if (s == 60) {
            ++m;
            s = 0;
        }
        if (m == 60) {
            ++d;
            m = 0;
        }
        return "" + d + "\u00b0" + m + "\u2032" + s + "\u2033";
    }

    private Geometry[] createPolarMatrix(Geometry geometry, Integer elementsNumberValue, Boolean rotateElementsValue, Point centerPointValue, Double angle) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        Geometry[] geometryMatrix = new Geometry[elementsNumberValue - 1];
        for (int i = 0; i < elementsNumberValue - 1; ++i) {
            AffineTransform at = new AffineTransform();
            if (rotateElementsValue.booleanValue()) {
                at = this.getRotateAffineTransform(centerPointValue, angle * (double)(i + 1));
            } else {
                at = this.getRotateAffineTransform(centerPointValue, angle * (double)(i + 1));
                double centerX = geometry.getEnvelope().getCenter(0);
                double centerY = geometry.getEnvelope().getCenter(1);
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                Point geometryCenter = geometryManager.createPoint(centerX, centerY, 0);
                Point geometryCenterCloned = geometryCenter.cloneGeometry();
                geometryCenterCloned.transform(at);
                at = this.getMoveAffineTransform(geometryCenter, geometryCenterCloned);
            }
            Geometry clonedGeometry = geometry.cloneGeometry();
            clonedGeometry.transform(at);
            geometryMatrix[i] = clonedGeometry;
        }
        return geometryMatrix;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.elementsNumber);
        parameters.add(this.rotateElements);
        parameters.add(this.centerPoint);
        parameters.add(this.elementAngle);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        boolean insertedValue = false;
        if (parameter.equals(this.selection) && value instanceof FeatureSelection) {
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() > 0L) {
                this.values.put(parameter, featureSelection);
                this.selectedFeatures = this.getSelectedFeaturesCopy(featureSelection);
                insertedValue = true;
            }
        } else if (parameter.equals(this.elementsNumber) && value instanceof Number) {
            double radians;
            int number = ((Number)value).intValue();
            Number angle = (Number)this.values.get(this.elementAngle);
            if (angle != null && (radians = Math.toRadians(angle.doubleValue())) > Math.PI * 2 / (double)(number - 1)) {
                throw new InvalidEntryException(null);
            }
            this.values.put(parameter, number);
            insertedValue = true;
        } else if (parameter.equals(this.rotateElements)) {
            this.values.put(parameter, parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
            insertedValue = true;
        } else if (parameter.equals(this.centerPoint) && value instanceof Point) {
            this.values.put(this.centerPoint, value);
            insertedValue = true;
        } else if (parameter.equals(this.elementAngle)) {
            if (value instanceof Double) {
                Integer elements = (Integer)this.values.get(this.elementsNumber);
                double radians = Math.toRadians((Double)value);
                if (elements != null && radians > Math.PI * 2 / (double)(elements - 1)) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(this.elementAngle, radians);
                insertedValue = true;
            } else if (value instanceof Point) {
                Point centerPointValue = (Point)this.values.get(this.centerPoint);
                Point valuePoint = (Point)value;
                double angle = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)valuePoint);
                Integer elements = (Integer)this.values.get(this.elementsNumber);
                if (elements != null && angle > Math.PI * 2 / (double)(elements - 1)) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(this.elementAngle, angle);
                insertedValue = true;
            }
        }
        if (!insertedValue) {
            throw new InvalidEntryException(null);
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
        Integer elementsNumberValue = (Integer)this.values.get(this.elementsNumber);
        Boolean rotateElementsValue = (Boolean)this.values.get(this.rotateElements);
        Point centerPointValue = (Point)this.values.get(this.centerPoint);
        Double elementAngleValue = (Double)this.values.get(this.elementAngle);
        if (CollectionUtils.isNotEmpty(this.selectedFeatures) && elementsNumberValue != null && rotateElementsValue != null && centerPointValue != null && elementAngleValue != null) {
            try {
                for (Feature feature : this.selectedFeatures) {
                    Geometry[] matrix;
                    Geometry geometry = feature.getDefaultGeometry();
                    LOGGER.info("elementAngleValue:" + elementAngleValue);
                    for (Geometry matrix1 : matrix = this.createPolarMatrix(geometry, elementsNumberValue, rotateElementsValue, centerPointValue, elementAngleValue)) {
                        EditableFeature eFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        eFeature.setDefaultGeometry(matrix1);
                        editingProviderServices.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
                    }
                }
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selection, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "insert-polar-matrix";
    }

    private AffineTransform getMoveAffineTransform(Point p1, Point p2) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return translate;
    }

    private AffineTransform getRotateAffineTransform(Point axisP1, Double angle) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(-axisP1.getX(), -axisP1.getY());
        AffineTransform rotate = AffineTransform.getRotateInstance(angle);
        AffineTransform inverseTranslate = AffineTransform.getTranslateInstance(axisP1.getX(), axisP1.getY());
        AffineTransform at = new AffineTransform(translate);
        at.preConcatenate(rotate);
        at.preConcatenate(inverseTranslate);
        return at;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

