/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import java.util.LinkedHashMap;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.web.util.JacksonUtil;

public class CrosstabInteractiveJsonHandler
implements GenericElementJsonHandler {
    public static final String PROPERTY_CROSSTAB_ID = "net.sf.jasperreports.export.crosstab.crosstabId";
    public static final String ATTRIBUTE_CROSSTAB_ID = "data-jrxtid";
    public static final String PROPERTY_COLUMN_INDEX = "net.sf.jasperreports.export.crosstab.columnIndex";
    public static final String ATTRIBUTE_COLUMN_INDEX = "data-jrxtcolidx";
    public static final String ELEMENT_PARAMETER_CROSSTAB_ID = "crosstabId";
    public static final String ELEMENT_PARAMETER_CROSSTAB_FRAGMENT_ID = "crosstabFragmentId";
    public static final String ELEMENT_PARAMETER_START_COLUMN_INDEX = "startColumnIndex";
    public static final String ELEMENT_PARAMETER_ROW_GROUPS = "rowGroups";
    public static final String ELEMENT_PARAMETER_DATA_COLUMNS = "dataColumns";
    public static final String ELEMENT_PARAMETER_FLOATING_HEADERS = "hasFloatingHeaders";

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    @Override
    public String getJsonFragment(JsonExporterContext exporterContext, JRGenericPrintElement element) {
        ReportContext reportContext = exporterContext.getExporterRef().getReportContext();
        String jsonFragment = null;
        if (reportContext != null) {
            LinkedHashMap<String, Object> elementInfo = new LinkedHashMap<String, Object>();
            String crosstabId = (String)element.getParameterValue(ELEMENT_PARAMETER_CROSSTAB_ID);
            String crosstabFragmentId = (String)element.getParameterValue(ELEMENT_PARAMETER_CROSSTAB_FRAGMENT_ID);
            if (crosstabFragmentId == null) {
                crosstabFragmentId = crosstabId;
            }
            elementInfo.put("type", "crosstab");
            elementInfo.put("module", "jive.crosstab");
            elementInfo.put("uimodule", "jive.crosstab.interactive");
            elementInfo.put("id", crosstabFragmentId);
            elementInfo.put("fragmentId", crosstabFragmentId);
            elementInfo.put(ELEMENT_PARAMETER_CROSSTAB_ID, crosstabId);
            elementInfo.put(ELEMENT_PARAMETER_START_COLUMN_INDEX, element.getParameterValue(ELEMENT_PARAMETER_START_COLUMN_INDEX));
            elementInfo.put(ELEMENT_PARAMETER_FLOATING_HEADERS, element.getParameterValue(ELEMENT_PARAMETER_FLOATING_HEADERS));
            elementInfo.put(ELEMENT_PARAMETER_ROW_GROUPS, element.getParameterValue(ELEMENT_PARAMETER_ROW_GROUPS));
            elementInfo.put(ELEMENT_PARAMETER_DATA_COLUMNS, element.getParameterValue(ELEMENT_PARAMETER_DATA_COLUMNS));
            String elementInfoJson = JacksonUtil.getInstance(exporterContext.getJasperReportsContext()).getJsonString(elementInfo);
            jsonFragment = "\"" + crosstabFragmentId + "\":" + elementInfoJson;
        }
        return jsonFragment;
    }
}

