/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.zip;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;

public class FileBufferedZipEntry
implements ExportZipEntry {
    private String name;
    private FileBufferedOutputStream fbos;
    private Writer writer;

    public FileBufferedZipEntry(String name) {
        this(name, null);
    }

    public FileBufferedZipEntry(String name, int memoryThreshold) {
        this.name = name;
        this.fbos = new FileBufferedOutputStream(memoryThreshold);
    }

    public FileBufferedZipEntry(String name, byte[] bytes) {
        this.name = name;
        if (bytes == null) {
            this.fbos = new FileBufferedOutputStream();
        } else {
            this.fbos = new FileBufferedOutputStream(bytes.length);
            try {
                this.fbos.write(bytes);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Writer getWriter() {
        if (this.writer == null) {
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fbos, "UTF-8"));
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.writer;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fbos;
    }

    @Override
    public void writeData(OutputStream os) throws IOException {
        this.fbos.writeData(os);
    }

    @Override
    public void dispose() {
        this.fbos.dispose();
    }
}

