/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.ExpressionValues;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public abstract class FillBaseExpressionValues
implements ExpressionValues {
    private final JREvaluator evaluator;
    private final Map<String, JRFillParameter> parametersMap;
    private final Map<String, JRFillField> fieldsMap;
    private final Map<String, JRFillVariable> variablesMap;

    protected FillBaseExpressionValues(JREvaluator evaluator, Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        this.evaluator = evaluator;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
    }

    @Override
    public Object getParameterValue(String parameterName) {
        JRFillParameter parameter = this.parametersMap.get(parameterName);
        if (parameter == null) {
            throw new JRRuntimeException("Parameter " + parameterName + " not found");
        }
        return parameter.getValue();
    }

    @Override
    public String getMessage(String messageKey) {
        return this.evaluator.str(messageKey);
    }

    protected JRFillField field(String fieldName) {
        JRFillField field = this.fieldsMap.get(fieldName);
        if (field == null) {
            throw new JRRuntimeException("Field " + fieldName + " not found");
        }
        return field;
    }

    protected JRFillVariable variable(String variableName) {
        JRFillVariable variable = this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRRuntimeException("Variable " + variableName + " not found");
        }
        return variable;
    }
}

