/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRCommonRectangle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateGraphicElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateRectangle
extends JRTemplateGraphicElement
implements JRCommonRectangle {
    private static final long serialVersionUID = 10200L;
    private Integer radius;

    protected JRTemplateRectangle(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRRectangle rectangle) {
        super(origin, defaultStyleProvider);
        this.setRectangle(rectangle);
    }

    protected JRTemplateRectangle(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRSubreport subreport) {
        super(origin, defaultStyleProvider);
        this.setSubreport(subreport);
    }

    public JRTemplateRectangle(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.linePen = new JRBasePen(this);
    }

    protected void setRectangle(JRRectangle rectangle) {
        super.setGraphicElement(rectangle);
        this.setRadius(rectangle.getRadius());
    }

    protected void setSubreport(JRSubreport subreport) {
        super.setElement(subreport);
        this.setMode(subreport.getModeValue());
        this.linePen = new JRBasePen(this);
        this.getLinePen().setLineWidth(Float.valueOf(0.0f));
        this.setFill(FillEnum.SOLID);
    }

    @Override
    public int getRadius() {
        return this.getStyleResolver().getRadius(this);
    }

    @Override
    public Integer getOwnRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addGraphicHash(hash);
        hash.add(this.radius);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateRectangle)) {
            return false;
        }
        JRTemplateRectangle template = (JRTemplateRectangle)object;
        return this.graphicIdentical(template) && ObjectUtils.equals(this.radius, template.radius);
    }
}

