/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.virtualization.DefaultSerializerRegistry;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.SerializationUtils;
import net.sf.jasperreports.engine.virtualization.SerializerRegistry;

public class VirtualizationInput
extends ObjectInputStream {
    public static final String EXCEPTION_MESSAGE_KEY_READ_OBJECT_FAILED = "engine.virtualization.input.read.object.failed";
    private final JRVirtualizationContext virtualizationContext;
    private final SerializerRegistry serializerRegistry = DefaultSerializerRegistry.getInstance();
    private final List<Object>[] readObjects = new List[48];

    public VirtualizationInput(InputStream in, JRVirtualizationContext virtualizationContext) throws IOException {
        super(in);
        this.virtualizationContext = virtualizationContext;
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    public int readIntCompressed() throws IOException {
        return SerializationUtils.readIntCompressed(this);
    }

    public Object readJRObject() throws IOException {
        return this.readJRObject(null);
    }

    public Object readJRObject(Boolean storeReference) throws IOException {
        int type = this.readUnsignedByte();
        if (type == 1) {
            return null;
        }
        if (type == 2) {
            try {
                return this.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_READ_OBJECT_FAILED, null, e);
            }
        }
        if ((type & 0x80) != 0) {
            int typeValue = type ^ 0x80;
            int objectIdx = this.readIntCompressed();
            return this.resolveReference(typeValue, objectIdx);
        }
        ObjectSerializer<?> typeSerializer = this.serializerRegistry.getSerializer(type);
        Object readObject = typeSerializer.read(this);
        if (storeReference == null ? typeSerializer.defaultStoreReference() : storeReference != false) {
            this.putReference(type, readObject);
        }
        return readObject;
    }

    protected Object resolveReference(int typeValue, int objectIndex) {
        List<Object> objects = this.readObjects[typeValue - 16];
        return objects.get(objectIndex);
    }

    protected void putReference(int typeValue, Object value) {
        List<Object> objects = this.readObjects[typeValue - 16];
        if (objects == null) {
            this.readObjects[typeValue - 16] = objects = new ArrayList<Object>();
        }
        objects.add(value);
    }
}

