/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.ProjectionLibrary;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.JCrsExtension;
import org.gvsig.crs.installer.EPSGDatabaseInstallerFactory;
import org.gvsig.crs.persistence.CompTrData;
import org.gvsig.crs.persistence.CrsData;
import org.gvsig.crs.persistence.TrData;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSPluginLibrary
extends AbstractLibrary {
    private String epsg_version = null;
    private static final Logger logger = LoggerFactory.getLogger(JCrsExtension.class);

    public void doRegistration() {
        this.registerAsServiceOf(ProjectionLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
        CrsData.registerPersistence();
        TrData.registerPersistence();
        CompTrData.registerPersistence();
        PluginServices plugin = PluginsLocator.getManager().getPlugin(JCrsExtension.class);
        DynObject properties = plugin.getPluginProperties();
        this.initalizeHomeDB(plugin);
        CrsFactory.setDataBaseFolder((File)new File(plugin.getPluginHomeFolder(), "db"));
        CrsFactory.setProjLibFolder((File)new File(plugin.getPluginHomeFolder(), "projlib"));
        CrsFactory.setEnableMemoryCacheOfCRS((boolean)BooleanUtils.isTrue((Boolean)((Boolean)properties.getDynValue("useMemoryCacheForCRSs"))));
        CrsFactory.setEpsgDatabaseFile((File)this.getDefaultEPSGDatabaseFile(plugin, properties));
        Integer databaseInitializationMode = (Integer)properties.getDynValue("databaseInitializationMode");
        switch (databaseInitializationMode == null ? 0 : databaseInitializationMode) {
            case 0: {
                CrsFactory.initializeDatabaseInbackground();
                break;
            }
            case 1: {
                CrsFactory.initializeDatabase();
                break;
            }
        }
        this.loadCustomCRSIdentificationFile(plugin);
        EPSGDatabaseInstallerFactory.registerEPSGDatabaseInstaller();
    }

    private void loadCustomCRSIdentificationFile(PluginServices plugin) {
        File customCRSIdentificationFile = new File(plugin.getPluginHomeFolder(), "customCRSIdentify.txt");
        try {
            int linenumber = 0;
            List lines = FileUtils.readLines((File)customCRSIdentificationFile);
            for (String line : lines) {
                try {
                    int n;
                    if ((line = line.trim()).startsWith("#") || (n = line.indexOf(" ")) < 0) continue;
                    String code_s = line.substring(0, n).trim();
                    String expression = line.substring(n + 1).trim();
                    if (StringUtils.isEmpty((CharSequence)expression) || StringUtils.isEmpty((CharSequence)code_s)) continue;
                    int code = Integer.parseInt(code_s);
                    CrsFactory.addCustomCRSIdentifyExpression((String)expression, (int)code);
                }
                catch (Exception ex) {
                    logger.warn("Can't process line " + linenumber + " from file " + customCRSIdentificationFile.getAbsolutePath() + ".", (Throwable)ex);
                }
                ++linenumber;
            }
        }
        catch (Exception ex) {
            logger.warn("Can't process file " + customCRSIdentificationFile.getAbsolutePath() + ".", (Throwable)ex);
        }
    }

    private File getDefaultEPSGDatabaseFile(PluginServices plugin, DynObject pluginProperties) {
        String fname = null;
        File dbfolder = null;
        try {
            File f2;
            dbfolder = new File(plugin.getPluginHomeFolder(), "db");
            fname = (String)pluginProperties.getDynValue("epsgDatabase");
            if (fname != null && (f2 = new File(dbfolder, fname)).exists()) {
                return new File(fname);
            }
            File folder = new File(dbfolder, "EPSG");
            ArrayList subfolders = new ArrayList(FileUtils.listFiles((File)folder, (String[])new String[]{"sql"}, (boolean)true));
            if (subfolders.size() > 0) {
                f2 = (File)subfolders.get(0);
                return f2;
            }
            logger.warn("Can't locate a EPSG database in folder '" + dbfolder + "' use '" + fname + "'.");
        }
        catch (Exception ex) {
            logger.warn("Can't locate a EPSG database in folder '" + dbfolder + "' use '" + fname + "'.", (Throwable)ex);
        }
        fname = "EPSG" + File.separator + this.getEmbeddedEPSGVersion() + File.separator + "EPSG.sql";
        return new File(fname);
    }

    private void initalizeHomeDB(PluginServices plugin) {
        File sourceDBFolder = new File(plugin.getPluginDirectory(), "db");
        File sourceProjLibFolder = new File(plugin.getPluginDirectory(), "projlib");
        File sourceEPSGFolder = new File(sourceDBFolder, "EPSG");
        File sourceCustomCRSIdentify = new File(plugin.getPluginDirectory(), "customCRSIdentify.txt");
        File targetDBFolder = new File(plugin.getPluginHomeFolder(), "db");
        File targetProjLibFolder = new File(plugin.getPluginHomeFolder(), "projlib");
        File targetEPSGFolder = new File(targetDBFolder, "EPSG");
        File targetCustomCRSIdentify = new File(plugin.getPluginHomeFolder(), "customCRSIdentify.txt");
        if (!targetDBFolder.exists()) {
            try {
                logger.info("Initializing CRS db in " + targetDBFolder.getAbsolutePath());
                FileUtils.forceMkdir((File)targetDBFolder);
                FileUtils.copyDirectory((File)sourceDBFolder, (File)targetDBFolder);
            }
            catch (IOException e) {
                logger.error("Can't initilize the CRS database in the gvSIG home (src=" + sourceDBFolder.getAbsolutePath() + ",target=" + targetDBFolder.getAbsolutePath() + ").", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!targetProjLibFolder.exists()) {
            try {
                logger.info("Initializing PROJ_LIB folder in " + targetProjLibFolder.getAbsolutePath());
                FileUtils.forceMkdir((File)targetProjLibFolder);
                FileUtils.copyDirectory((File)sourceProjLibFolder, (File)targetProjLibFolder);
            }
            catch (IOException e) {
                logger.error("Can't initilize the PROJ_LIB folder in the gvSIG home (src=" + sourceProjLibFolder.getAbsolutePath() + ",target=" + targetProjLibFolder.getAbsolutePath() + ").", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!targetEPSGFolder.exists()) {
            try {
                logger.info("Initializing EPSG database folder in " + targetEPSGFolder.getAbsolutePath());
                FileUtils.forceMkdir((File)targetEPSGFolder);
                FileUtils.copyDirectory((File)sourceEPSGFolder, (File)targetEPSGFolder);
            }
            catch (IOException e) {
                logger.error("Can't initilize EPSG database folder in the gvSIG home (src=" + sourceEPSGFolder.getAbsolutePath() + ",target=" + targetEPSGFolder.getAbsolutePath() + ").", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!(targetEPSGFolder = new File(targetEPSGFolder, this.getEmbeddedEPSGVersion())).exists()) {
            sourceEPSGFolder = new File(sourceEPSGFolder, this.getEmbeddedEPSGVersion());
            try {
                logger.info("Initializing EPSG database folder in " + targetEPSGFolder.getAbsolutePath());
                FileUtils.forceMkdir((File)targetEPSGFolder);
                FileUtils.copyDirectory((File)sourceEPSGFolder, (File)targetEPSGFolder);
            }
            catch (IOException e) {
                logger.error("Can't initilize EPSG database folder in the gvSIG home (src=" + sourceEPSGFolder.getAbsolutePath() + ",target=" + targetEPSGFolder.getAbsolutePath() + ").", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!targetCustomCRSIdentify.exists()) {
            try {
                logger.info("Initializing Custom CRS identification file in " + targetCustomCRSIdentify.getAbsolutePath());
                FileUtils.copyFile((File)sourceCustomCRSIdentify, (File)targetCustomCRSIdentify);
            }
            catch (IOException e) {
                logger.error("Can't initilize Custom CRS identification file in the gvSIG home (src=" + sourceCustomCRSIdentify.getAbsolutePath() + ",target=" + targetCustomCRSIdentify.getAbsolutePath() + ").", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void doPostInitialize() throws LibraryException {
    }

    private String getEmbeddedEPSGVersion() {
        if (this.epsg_version == null) {
            PluginsManager pluginManager = PluginsLocator.getManager();
            PluginServices plugin = pluginManager.getPlugin((Object)this);
            File folder = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"db", "EPSG"});
            Object[] files = folder.listFiles();
            if (ArrayUtils.isEmpty((Object[])files)) {
                logger.warn("Can't locate embedded EPSG version.");
                return null;
            }
            this.epsg_version = ((File)files[0]).getName();
        }
        return this.epsg_version;
    }
}

