/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.InfoCRSPanel;
import org.gvsig.crs.gui.panels.NewCRSPanel;
import org.gvsig.crs.persistence.CrsData;
import org.gvsig.crs.persistence.RecentCRSsPersistence;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsAndTransformationRecentsPanel
extends JPanel
implements ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(CrsAndTransformationRecentsPanel.class);
    private static final long serialVersionUID = 1L;
    public JTable jTable = null;
    private JScrollPane jScrollPane = null;
    private JButton infoCrs = null;
    public DefaultTableModel dtm = null;
    public TableSorter sorter = null;
    private CrsData[] crsDataArray = null;
    private TrData[] crsTrDataArray = null;
    public int selectedRowTable = -1;
    private String authority = null;
    private int codeCRS = -1;
    private ICrs crs = null;
    private ArrayList recents = null;

    public CrsAndTransformationRecentsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0, 15, 15));
        p.add(this.getJLabel());
        this.add((Component)p, "North");
        this.add((Component)this.getJScrollPane(), "Center");
        JPanel pSouth = new JPanel(new FlowLayout(2, 5, 5));
        pSouth.add(this.getInfoCrs());
        this.add((Component)pSouth, "South");
    }

    private JLabel getJLabel() {
        JLabel label = new JLabel();
        label.setText(PluginServices.getText((Object)this, (String)"ultimos_crs_utilizados") + ":");
        return label;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"fuente"), PluginServices.getText((Object)this, (String)"codigo"), PluginServices.getText((Object)this, (String)"nombre"), PluginServices.getText((Object)this, (String)"transformation")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.jTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.jTable.getTableHeader());
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < columnNames.length; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(60);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(60);
                    continue;
                }
                column.setPreferredWidth(240);
            }
        }
        return this.jTable;
    }

    public JButton getInfoCrs() {
        if (this.infoCrs == null) {
            this.infoCrs = new JButton();
            this.infoCrs.setPreferredSize(new Dimension(85, 20));
            this.infoCrs.setText(PluginServices.getText((Object)this, (String)"infocrs"));
            this.infoCrs.setMnemonic('I');
            this.infoCrs.setEnabled(false);
            this.infoCrs.setToolTipText(PluginServices.getText((Object)this, (String)"more_info"));
            this.infoCrs.addActionListener(this);
        }
        return this.infoCrs;
    }

    public ICrs getProjection() {
        return this.crs;
    }

    public void setCodeCRS(int code) {
        this.codeCRS = code;
    }

    public int getCodeCRS() {
        return this.codeCRS;
    }

    public void setProjection(IProjection crs) {
    }

    public void loadRecents(CrsWkt crsWkttarget, ICrs curCrs) {
        int numr;
        Object[] row;
        String crsTarget;
        String crsSource;
        String target;
        Object[] row2;
        Object[] first;
        RecentTrsPersistence trPersistence = new RecentTrsPersistence();
        this.crsTrDataArray = trPersistence.getArrayOfTrData();
        RecentCRSsPersistence persistence = new RecentCRSsPersistence();
        if (curCrs != null) {
            CrsData crsData = new CrsData(curCrs.getCrsWkt().getAuthority()[0], curCrs.getCode(), curCrs.getCrsWkt().getName());
            if (curCrs.getSourceTransformationParams() == null && curCrs.getTargetTransformationParams() == null) {
                persistence.addCrsData(crsData);
            }
        }
        this.crsDataArray = persistence.getArrayOfCrsData();
        boolean available = true;
        if (this.crsDataArray.length == 0) {
            return;
        }
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        int initialCrsTr = this.crsTrDataArray.length - 1;
        int initialCrs = this.crsDataArray.length - 1;
        if (curCrs != null && (curCrs.getSourceTransformationParams() != null || curCrs.getTargetTransformationParams() != null)) {
            initialCrsTr = this.crsTrDataArray.length - 1;
            first = new Object[]{this.crsTrDataArray[initialCrsTr].getCrsSource().split(":")[0], this.crsTrDataArray[initialCrsTr].getCrsSource().split(":")[1], this.crsTrDataArray[initialCrsTr].getName(), this.crsTrDataArray[initialCrsTr].getAuthority() + ":" + this.crsTrDataArray[initialCrsTr].getCode() + " <--> " + this.crsTrDataArray[initialCrsTr].getDetails()};
            if (this.crsTrDataArray[initialCrsTr].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                available = this.isUSR(this.crsTrDataArray[initialCrsTr].getCode());
            }
            if (available) {
                this.dtm.addRow(first);
                initialCrsTr = this.crsTrDataArray.length - 2;
            } else {
                available = true;
            }
        } else {
            initialCrs = this.crsDataArray.length - 1;
            first = new Object[]{this.crsDataArray[initialCrs].getAuthority(), Integer.toString(this.crsDataArray[initialCrs].getCode()), this.crsDataArray[initialCrs].getName(), PluginServices.getText((Object)this, (String)"sin_transformacion")};
            if (this.crsDataArray[initialCrs].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                available = this.isUSR(this.crsDataArray[initialCrs].getCode());
            }
            if (available) {
                this.dtm.addRow(first);
                initialCrs = this.crsDataArray.length - 2;
            } else {
                available = true;
            }
        }
        int iRowCrs = initialCrs;
        int iRowTr = initialCrsTr;
        while (iRowCrs >= 0 && iRowTr >= 0) {
            if (this.crsDataArray[iRowCrs].getDate().after(this.crsTrDataArray[iRowTr].getDate())) {
                if (this.crsDataArray[iRowCrs].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                    available = this.isUSR(this.crsDataArray[iRowCrs].getCode());
                }
                if (available) {
                    row2 = new Object[]{this.crsDataArray[iRowCrs].getAuthority(), Integer.toString(this.crsDataArray[iRowCrs].getCode()), this.crsDataArray[iRowCrs].getName(), PluginServices.getText((Object)this, (String)"sin_transformacion")};
                    this.dtm.addRow(row2);
                } else {
                    available = true;
                }
                --iRowCrs;
                continue;
            }
            target = crsWkttarget.getAuthority()[0] + ":" + crsWkttarget.getAuthority()[1];
            crsSource = this.crsTrDataArray[iRowTr].getCrsSource();
            crsTarget = this.crsTrDataArray[iRowTr].getCrsTarget();
            if (target.equals(crsTarget)) {
                if (this.crsTrDataArray[iRowTr].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                    available = this.isUSR(this.crsTrDataArray[iRowTr].getCode());
                }
                if (available) {
                    row = new Object[]{crsSource.split(":")[0], crsSource.split(":")[1], this.crsTrDataArray[iRowTr].getName(), this.crsTrDataArray[iRowTr].getAuthority() + ":" + this.crsTrDataArray[iRowTr].getCode() + " <--> " + this.crsTrDataArray[iRowTr].getDetails()};
                    this.dtm.addRow(row);
                } else {
                    available = true;
                }
            }
            --iRowTr;
        }
        if (iRowTr >= 0) {
            while (iRowTr >= 0) {
                target = crsWkttarget.getAuthority()[0] + ":" + crsWkttarget.getAuthority()[1];
                crsSource = this.crsTrDataArray[iRowTr].getCrsSource();
                crsTarget = this.crsTrDataArray[iRowTr].getCrsTarget();
                if (target.equals(crsTarget)) {
                    if (this.crsTrDataArray[iRowTr].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                        available = this.isUSR(this.crsTrDataArray[iRowTr].getCode());
                    }
                    if (available) {
                        row = new Object[]{crsSource.split(":")[0], crsSource.split(":")[1], this.crsTrDataArray[iRowTr].getName(), this.crsTrDataArray[iRowTr].getAuthority() + ":" + this.crsTrDataArray[iRowTr].getCode() + " <--> " + this.crsTrDataArray[iRowTr].getDetails()};
                        this.dtm.addRow(row);
                    } else {
                        available = true;
                    }
                }
                --iRowTr;
            }
        } else {
            while (iRowCrs >= 0) {
                if (this.crsDataArray[iRowCrs].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                    available = this.isUSR(this.crsDataArray[iRowCrs].getCode());
                }
                if (available) {
                    row2 = new Object[]{this.crsDataArray[iRowCrs].getAuthority(), Integer.toString(this.crsDataArray[iRowCrs].getCode()), this.crsDataArray[iRowCrs].getName(), PluginServices.getText((Object)this, (String)"sin_transformacion")};
                    this.dtm.addRow(row2);
                } else {
                    available = true;
                }
                --iRowCrs;
            }
        }
        if ((numr = this.dtm.getRowCount()) != 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public boolean isUSR(int code) {
        NewCRSPanel usr = new NewCRSPanel();
        return usr.isInBD(code);
    }

    public ICrs getCrs() {
        return this.crs;
    }

    public void initCrs() {
        this.selectedRowTable = this.getJTable().getSelectedRow();
        Integer.parseInt((String)this.sorter.getValueAt(this.selectedRowTable, 1));
        this.setAuthority((String)this.sorter.getValueAt(this.selectedRowTable, 0) + ":" + (String)this.sorter.getValueAt(this.selectedRowTable, 1));
        this.codeCRS = Integer.parseInt((String)this.sorter.getValueAt(this.selectedRowTable, 1));
        try {
            this.crs = new CrsFactory().getCRS(this.getAuthority());
        }
        catch (CrsException e) {
            logger.error("Can't create CRS from authority (" + this.authority + ").", (Throwable)e);
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String aut) {
        this.authority = aut;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getInfoCrs()) {
            String[] aut = this.getAuthority().split(":");
            InfoCRSPanel info = new InfoCRSPanel(aut[0], this.getCodeCRS(), (String)this.getJTable().getValueAt(this.getJTable().getSelectedRow(), 3));
            PluginServices.getMDIManager().addWindow((IWindow)info);
        }
    }
}

