/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.InfoCRSPanel;
import org.gvsig.crs.ogr.CrsEPSG;
import org.gvsig.crs.ogr.Epsg2wkt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPSGpanel
extends JPanel
implements KeyListener,
ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(EPSGpanel.class);
    private static final long serialVersionUID = 1L;
    String cadWKT = "";
    String cad_valida = "";
    public String key;
    public String crs_kind = null;
    String[] soported_crs = new String[]{"projected", "geographic 2D", "geographic 3D", "engineering", "vertical", "compound", "geocentric"};
    String[] not_soported_crs = new String[0];
    int iteracion = 0;
    int transf = 0;
    int source_cod = 0;
    int method_code = 0;
    int datum_code = 0;
    int projection_conv_code = 0;
    public int epsg_code = 0;
    public int selectedRowTable = -1;
    private int codeCRS = -1;
    int[] valid_method_code = new int[]{1024, 9800, 9801, 9802, 9803, 9804, 9805, 9806, 9807, 9808, 9809, 9810, 9811, 9812, 9813, 9814, 9815, 9816, 9817, 9602, 9659, 9818, 9819, 9820, 9822, 9827};
    boolean tecla_valida = false;
    boolean source_yn = false;
    private JRadioButton codeRadioButton = null;
    private JRadioButton nameRadioButton = null;
    private JRadioButton areaRadioButton = null;
    private ButtonGroup optGroup;
    private JPanel groupRadioButton = null;
    public EpsgConnection connect = null;
    public JPanel EPSGpanel = null;
    private JLabel lblCriterio;
    private JButton infoCrs = null;
    private JButton searchButton = null;
    private JTextField searchTextField = null;
    public JTable jTable = null;
    private JScrollPane jScrollPane = null;
    public DefaultTableModel dtm = null;
    public TableSorter sorter = null;
    private int projectionCode = -1;

    public EPSGpanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel pNorth = new JPanel();
        pNorth.setLayout(new GridLayout(2, 1));
        pNorth.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        pNorth.add(this.getGroupRadioButton());
        JPanel pInNorth = new JPanel();
        pInNorth.setLayout(new FlowLayout(0, 10, 1));
        pInNorth.add(this.getSearchButton());
        pInNorth.add(this.getSearchTextField());
        pNorth.add(pInNorth);
        this.add((Component)pNorth, "North");
        this.add((Component)this.getJScrollPane(), "Center");
        JPanel pSouth = new JPanel(new FlowLayout(2, 10, 3));
        pSouth.add(this.getInfoCrs());
        this.add((Component)pSouth, "South");
    }

    public void connection() {
        this.connect = new EpsgConnection();
        this.connect.setConnectionEPSG();
    }

    private JRadioButton getCodeRadioButton() {
        if (this.codeRadioButton == null) {
            this.codeRadioButton = new JRadioButton();
            this.codeRadioButton.setText(PluginServices.getText((Object)this, (String)"por_codigo"));
            this.codeRadioButton.setSelected(true);
            this.codeRadioButton.addActionListener(this);
        }
        return this.codeRadioButton;
    }

    private JRadioButton getNameRadioButton() {
        if (this.nameRadioButton == null) {
            this.nameRadioButton = new JRadioButton();
            this.nameRadioButton.setText(PluginServices.getText((Object)this, (String)"por_nombre"));
            this.nameRadioButton.addActionListener(this);
        }
        return this.nameRadioButton;
    }

    private JRadioButton getAreaRadioButton() {
        if (this.areaRadioButton == null) {
            this.areaRadioButton = new JRadioButton();
            this.areaRadioButton.setText(PluginServices.getText((Object)this, (String)"por_area"));
            this.areaRadioButton.addActionListener(this);
        }
        return this.areaRadioButton;
    }

    private JPanel getGroupRadioButton() {
        if (this.groupRadioButton == null) {
            this.groupRadioButton = new JPanel();
            this.groupRadioButton.setLayout(new GridLayout(1, 4));
            this.groupRadioButton.add(this.getLblCriterio());
            this.groupRadioButton.add(this.getCodeRadioButton());
            this.groupRadioButton.add(this.getNameRadioButton());
            this.groupRadioButton.add(this.getAreaRadioButton());
            this.getOptGroup();
        }
        return this.groupRadioButton;
    }

    private JLabel getLblCriterio() {
        this.lblCriterio = new JLabel();
        this.lblCriterio.setText(PluginServices.getText((Object)this, (String)"criterio_busqueda") + ":");
        return this.lblCriterio;
    }

    private void searchButton() {
        boolean not_valid = false;
        boolean not_numeric = false;
        this.searchTextField.setBackground(Color.white);
        if (this.searchTextField.getText().equals("")) {
            this.searchTextField.setBackground(new Color(255, 204, 204));
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"fill_name"), PluginServices.getText((Object)this, (String)"warning"), 2);
        } else {
            int numRow = this.dtm.getRowCount();
            while (numRow != 0) {
                this.dtm.removeRow(--numRow);
            }
            this.key = this.searchTextField.getText();
            if (this.codeRadioButton.isSelected() && this.key.length() != this.key.replaceAll("[^0-9]", "").length()) {
                not_numeric = true;
            }
            ResultSet result = null;
            String sentence = null;
            String select = "SELECT coord_ref_sys_code, coord_ref_sys_name, coord_ref_sys_kind, area_of_use_code, source_geogcrs_code, projection_conv_code, deprecated, epsg_area.area_name, epsg_area.area_of_use FROM epsg_coordinatereferencesystem INNER JOIN epsg_area ON (epsg_coordinatereferencesystem.area_of_use_code = epsg_area.area_code) ";
            String condition1 = null;
            String condition2 = "AND (deprecated = 0) AND (coord_ref_sys_kind IN ('geographic 2D', 'projected')) ORDER BY coord_ref_sys_name";
            if (this.codeRadioButton.isSelected() && !not_numeric) {
                this.key = this.searchTextField.getText();
                int code = Integer.parseInt(this.key);
                condition1 = "WHERE coord_ref_sys_code = " + code + " ";
                sentence = select + condition1 + condition2;
                result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            } else if (this.nameRadioButton.isSelected()) {
                this.key = this.searchTextField.getText();
                this.key = this.key.toLowerCase();
                condition1 = "WHERE (LCASE(coord_ref_sys_name) LIKE '%" + this.key + "%') ";
                sentence = select + condition1 + condition2;
                result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            } else if (this.areaRadioButton.isSelected()) {
                this.key = this.searchTextField.getText();
                this.key = this.key.toLowerCase();
                condition1 = "WHERE ((LCASE(epsg_area.area_name) LIKE '%" + this.key + "%') " + "OR (LCASE(epsg_area.area_of_use) LIKE '%" + this.key + "%')) ";
                sentence = select + condition1 + condition2;
                result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            }
            if (result != null) {
                try {
                    while (result.next()) {
                        Object[] data = new Object[5];
                        data[0] = result.getString("coord_ref_sys_code");
                        data[1] = result.getString("coord_ref_sys_name");
                        this.crs_kind = result.getString("coord_ref_sys_kind");
                        data[2] = this.crs_kind;
                        this.projection_conv_code = result.getInt("projection_conv_code");
                        this.setProjectionCode(this.projection_conv_code);
                        data[3] = result.getString("area_name");
                        data[4] = result.getString("area_of_use");
                        if (data[0] == null || !this.valid(this.crs_kind)) continue;
                        this.dtm.addRow(data);
                    }
                }
                catch (SQLException e1) {
                    logger.error("Can't get values from RecordSet.", (Throwable)e1);
                }
            }
            int numr = this.dtm.getRowCount();
            if (not_valid) {
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"crs_not_soported"), PluginServices.getText((Object)this, (String)"warning"), 2);
                not_valid = false;
            } else if (not_numeric) {
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format"), PluginServices.getText((Object)this, (String)"warning"), 2);
                this.searchTextField.setText("");
            } else if (numr == 0) {
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"no_results"), PluginServices.getText((Object)this, (String)"warning"), 2);
            } else {
                this.getJTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    private boolean notValid(String kind) {
        for (int i = 0; i < this.not_soported_crs.length; ++i) {
            if (!kind.equals(this.not_soported_crs[i])) continue;
            return true;
        }
        return false;
    }

    private boolean valid(String kind) {
        for (int i = 0; i < this.soported_crs.length; ++i) {
            if (!kind.equals(this.soported_crs[i])) continue;
            return true;
        }
        return false;
    }

    private boolean validCRS(int projection_conv_code2) {
        if (projection_conv_code2 == 0) {
            return true;
        }
        String sentence = "SELECT coord_op_method_code FROM epsg_coordoperation WHERE coord_op_code = " + this.projection_conv_code;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            while (result.next()) {
                this.method_code = result.getInt("coord_op_method_code");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e);
        }
        for (int i = 0; i < this.valid_method_code.length; ++i) {
            if (this.method_code != this.valid_method_code[i]) continue;
            return true;
        }
        return false;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setPreferredSize(new Dimension(75, 20));
            this.searchButton.setText(PluginServices.getText((Object)this, (String)"buscar"));
            this.searchButton.setMnemonic('S');
            this.searchButton.setToolTipText(PluginServices.getText((Object)this, (String)"buscar_por_criterio_seleccion"));
            this.searchButton.addActionListener(this);
        }
        return this.searchButton;
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setPreferredSize(new Dimension(350, 20));
            this.searchTextField.addKeyListener(this);
        }
        return this.searchTextField;
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"codigo"), PluginServices.getText((Object)this, (String)"nombre"), PluginServices.getText((Object)this, (String)"tipo"), PluginServices.getText((Object)this, (String)"area"), PluginServices.getText((Object)this, (String)"descripcion")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.jTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.jTable.getTableHeader());
            this.jTable.setAutoResizeMode(0);
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < columnNames.length; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(80);
                    continue;
                }
                if (i == 4) {
                    column.setPreferredWidth(300);
                    continue;
                }
                column.setPreferredWidth(140);
            }
        }
        return this.jTable;
    }

    public void setCodeCRS(int code) {
        this.codeCRS = code;
    }

    public int getCodeCRS() {
        return this.codeCRS;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(this.getJTable(), 20, 32);
            this.jScrollPane.setPreferredSize(new Dimension(500, 150));
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    public JButton getInfoCrs() {
        if (this.infoCrs == null) {
            this.infoCrs = new JButton();
            this.infoCrs.setPreferredSize(new Dimension(85, 20));
            this.infoCrs.setText(PluginServices.getText((Object)this, (String)"infocrs"));
            this.infoCrs.setMnemonic('I');
            this.infoCrs.setEnabled(false);
            this.infoCrs.setToolTipText(PluginServices.getText((Object)this, (String)"more_info"));
            this.infoCrs.addActionListener(this);
        }
        return this.infoCrs;
    }

    public ICrs getProjection() {
        try {
            String txt = this.getWKT();
            ICrs crs = new CrsFactory().getCRS("EPSG:" + this.epsg_code);
            return crs;
        }
        catch (CrsException e) {
            logger.error("Can't create EPSG CRS from code  " + this.epsg_code + ".", (Throwable)e);
            return null;
        }
    }

    public void setWKT() {
        Epsg2wkt wkt = null;
        this.epsg_code = this.getCodeCRS();
        if (this.epsg_code != -1) {
            String sentence = "SELECT source_geogcrs_code, projection_conv_code, coord_ref_sys_kind, datum_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + this.epsg_code;
            ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            try {
                result.next();
                this.source_cod = result.getInt("source_geogcrs_code");
                this.projection_conv_code = result.getInt("projection_conv_code");
                this.crs_kind = result.getString("coord_ref_sys_kind");
                this.datum_code = result.getInt("datum_code");
            }
            catch (SQLException e1) {
                logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e1);
            }
            this.source_yn = this.datum_code != 0 ? true : this.source_cod == 0;
            CrsEPSG ep = new CrsEPSG(this.epsg_code, this.source_yn, this.source_cod, this.projection_conv_code, this.connect);
            if (this.crs_kind.equals("geographic 2D") || this.crs_kind.equals("geographic 3D")) {
                wkt = new Epsg2wkt(ep, "geog");
            } else if (this.crs_kind.equals("projected")) {
                wkt = new Epsg2wkt(ep, "proj");
            } else if (this.crs_kind.equals("compound")) {
                wkt = new Epsg2wkt(ep, "comp");
            } else if (this.crs_kind.equals("geocentric")) {
                wkt = new Epsg2wkt(ep, "geoc");
            }
        } else {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"crs_no_selected."), PluginServices.getText((Object)this, (String)"warning"), 2);
        }
        this.cadWKT = wkt.getWKT();
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public void setProjection(IProjection crs) {
    }

    public void loadViewCRS(int code) {
        this.connection();
        String sentence = "SELECT coord_ref_sys_code, coord_ref_sys_name, coord_ref_sys_kind, area_of_use_code, source_geogcrs_code, projection_conv_code, deprecated  FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + code + " AND deprecated = 0";
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            result.next();
            Object[] data = new Object[5];
            data[0] = result.getString("coord_ref_sys_code");
            data[1] = result.getString("coord_ref_sys_name");
            this.crs_kind = result.getString("coord_ref_sys_kind");
            data[2] = this.crs_kind;
            this.projection_conv_code = result.getInt("projection_conv_code");
            int area_of_use_code = Integer.parseInt(result.getString("area_of_use_code"));
            sentence = "SELECT area_name, area_of_use FROM epsg_area WHERE area_code = " + area_of_use_code;
            ResultSet result2 = Query.select((String)sentence, (Connection)this.connect.getConnection());
            result2.next();
            data[3] = result2.getString("area_name");
            data[4] = result2.getString("area_of_use");
            this.dtm.addRow(data);
        }
        catch (SQLException e1) {
            logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e1);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.getSearchTextField() && e.getKeyCode() == 10) {
            this.searchButton();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCodeRadioButton()) {
            this.searchTextField.setText("");
        }
        if (e.getSource() == this.getNameRadioButton()) {
            this.searchTextField.setText("");
        }
        if (e.getSource() == this.getAreaRadioButton()) {
            this.searchTextField.setText("");
        }
        if (e.getSource() == this.getSearchButton()) {
            this.searchTextField.setBackground(Color.white);
            if (this.searchTextField.getText().equals("")) {
                this.searchTextField.setBackground(new Color(255, 204, 204));
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"fill_name"), PluginServices.getText((Object)this, (String)"warning"), 2);
            } else {
                this.searchButton();
            }
        }
        if (e.getSource() == this.getInfoCrs()) {
            InfoCRSPanel info = new InfoCRSPanel("EPSG", this.getCodeCRS());
            PluginServices.getMDIManager().addWindow((IWindow)info);
        }
    }

    public ButtonGroup getOptGroup() {
        if (this.optGroup == null) {
            this.optGroup = new ButtonGroup();
            this.optGroup.add(this.getCodeRadioButton());
            this.optGroup.add(this.getNameRadioButton());
            this.optGroup.add(this.getAreaRadioButton());
        }
        return this.optGroup;
    }

    public void setProjectionCode(int projCode) {
        String sentence = "SELECT coord_op_method_code FROM epsg_coordoperation WHERE coord_op_code = " + projCode;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            while (result.next()) {
                this.projectionCode = result.getInt("coord_op_method_code");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e);
        }
    }

    public int getProjectionCode(String code) {
        int cod = Integer.parseInt(code);
        String sentence = "SELECT projection_conv_code  FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + code;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        int projCode = 0;
        try {
            while (result.next()) {
                projCode = result.getInt("projection_conv_code");
            }
        }
        catch (SQLException e1) {
            logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e1);
        }
        sentence = "SELECT coord_op_method_code FROM epsg_coordoperation WHERE coord_op_code = " + projCode;
        result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            while (result.next()) {
                this.projectionCode = result.getInt("coord_op_method_code");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e);
        }
        return this.projectionCode;
    }
}

