/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.TableSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoTransformationsRecentsPanel
extends JPanel
implements IWindow,
ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(InfoTransformationsRecentsPanel.class);
    private static final long serialVersionUID = 1L;
    private JTable jTable;
    public DefaultTableModel dtm = null;
    private JScrollPane jScrollPane1 = null;
    private JPanel jPanelbuttons;
    private JButton jButtonOk;
    public TableSorter sorter = null;
    String[] data = null;
    private int v_height = 200;
    private int v_width = 420;

    public InfoTransformationsRecentsPanel(String[] data) {
        this.data = data;
        this.inicializate();
    }

    private void inicializate() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane1(), "Center");
        this.add((Component)this.getJPanelButtons(), "South");
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelbuttons == null) {
            this.jPanelbuttons = new JPanel();
            this.jPanelbuttons.setLayout(new FlowLayout(2, 10, 10));
            this.jPanelbuttons.add((Component)this.getJButtonOk(), null);
        }
        return this.jPanelbuttons;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(PluginServices.getText((Object)this, (String)"ok"));
            this.jButtonOk.setPreferredSize(new Dimension(100, 25));
            this.jButtonOk.setMnemonic('O');
            this.jButtonOk.setToolTipText(PluginServices.getText((Object)this, (String)"ok"));
            this.jButtonOk.addActionListener(this);
        }
        return this.jButtonOk;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setPreferredSize(new Dimension(400, 150));
            this.jScrollPane1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"info_transformations")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.jScrollPane1.getBorder()));
            this.jScrollPane1.setViewportView(this.getJTable());
        }
        return this.jScrollPane1;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"nombre"), PluginServices.getText((Object)this, (String)"valor")};
            Object[][] datos = this.obtainData();
            this.dtm = new DefaultTableModel(datos, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.jTable = new JTable((TableModel)this.sorter);
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
        }
        return this.jTable;
    }

    private String[][] obtainData() {
        String[][] valid = null;
        String[] transformation = this.data[0].split(":");
        if (transformation[0].equals("EPSG")) {
            valid = new String[6][2];
            valid[0][0] = PluginServices.getText((Object)this, (String)"source_crs");
            valid[0][1] = this.data[2];
            valid[1][0] = PluginServices.getText((Object)this, (String)"target_crs");
            valid[1][1] = this.data[3];
            EpsgConnection conn = new EpsgConnection();
            conn.setConnectionEPSG();
            String sentence = "SELECT area_of_use_code FROM epsg_coordoperation WHERE coord_op_code = " + transformation[1];
            ResultSet result = Query.select((String)sentence, (Connection)conn.getConnection());
            try {
                result.next();
                valid[2][0] = PluginServices.getText((Object)this, (String)"transformation_code");
                valid[2][1] = transformation[1];
                sentence = "SELECT area_of_use FROM epsg_area WHERE area_code = " + Integer.parseInt(result.getString("area_of_use_code"));
            }
            catch (SQLException e) {
                logger.error("Can't create SQL.", (Throwable)e);
            }
            valid[3][0] = PluginServices.getText((Object)this, (String)"transformation_name");
            valid[3][1] = this.data[1];
            valid[4][0] = PluginServices.getText((Object)this, (String)"details");
            result = Query.select((String)sentence, (Connection)conn.getConnection());
            try {
                result.next();
                valid[4][1] = result.getString("area_of_use");
            }
            catch (SQLException e) {
                logger.error("Can't get values from RecordSet (sentence='" + sentence + "').", (Throwable)e);
            }
        } else if (transformation[0].equals("USR")) {
            valid = new String[3][2];
            valid[0][0] = PluginServices.getText((Object)this, (String)"source_crs");
            valid[0][1] = this.data[2];
            valid[1][0] = PluginServices.getText((Object)this, (String)"target_crs");
            valid[1][1] = this.data[3];
            valid[2][0] = PluginServices.getText((Object)this, (String)"details");
            valid[2][1] = this.data[4];
        } else {
            valid = new String[4][2];
            String[] partes = this.data[4].split("\\(");
            String nadFile = partes[0];
            String codigoNad = partes[1].substring(0, partes[1].length() - 1);
            valid[0][0] = PluginServices.getText((Object)this, (String)"source_crs");
            valid[0][1] = this.data[2];
            valid[1][0] = PluginServices.getText((Object)this, (String)"target_crs");
            valid[1][1] = this.data[3];
            valid[2][0] = PluginServices.getText((Object)this, (String)"nadgrids_file");
            valid[2][1] = nadFile;
            valid[3][0] = PluginServices.getText((Object)this, (String)"calculated_in");
            valid[3][1] = codigoNad;
        }
        return valid;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle("Info");
        m_viewinfo.setHeight(this.v_height);
        m_viewinfo.setWidth(this.v_width);
        return m_viewinfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJButtonOk()) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

