/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import es.idr.teledeteccion.connection.EpsgConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.ogr.TransEPSG;
import org.gvsig.crs.persistence.CompTrData;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationRecentsPanel
extends JPanel {
    public static final Logger logger = LoggerFactory.getLogger(TransformationRecentsPanel.class);
    private static final long serialVersionUID = 1L;
    int code = 0;
    private JTable transformationTable;
    private JScrollPane jScrollPane = null;
    public DefaultTableModel dtm = null;
    public TableSorter sorter = null;
    JButton JButtonInfo = null;
    public int selectedRowTable = -1;
    private TrData[] trDataArray;
    private String cadWKT = "";
    private String params = "";
    public EpsgConnection connect = null;
    boolean inverseTransformation = false;
    int trCode;
    boolean targetNad = false;
    String sourceAbrev = null;

    public TransformationRecentsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.connect = new EpsgConnection();
        this.connect.setConnectionEPSG();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"recents_transformation")), BorderFactory.createEmptyBorder(2, 2, 2, 2)), this.getBorder()));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0, 10, 10));
        p.add(this.getJButtonInfo());
        this.add((Component)p, "North");
        this.add((Component)this.getJScrollPane(), "Center");
    }

    public JTable getJTable() {
        if (this.transformationTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"transformation"), PluginServices.getText((Object)this, (String)"name"), PluginServices.getText((Object)this, (String)"source_crs"), PluginServices.getText((Object)this, (String)"target_crs"), PluginServices.getText((Object)this, (String)"detalles")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.transformationTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.transformationTable.getTableHeader());
            this.transformationTable.setCellSelectionEnabled(false);
            this.transformationTable.setRowSelectionAllowed(true);
            this.transformationTable.setAutoResizeMode(0);
            this.transformationTable.setColumnSelectionAllowed(false);
            this.transformationTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < columnNames.length; ++i) {
                column = this.transformationTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(80);
                    continue;
                }
                if (i == 4) {
                    column.setPreferredWidth(200);
                    continue;
                }
                column.setPreferredWidth(100);
            }
        }
        return this.transformationTable;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"transformations")), BorderFactory.createEmptyBorder(12, 5, 70, 5)), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    public JButton getJButtonInfo() {
        if (this.JButtonInfo == null) {
            this.JButtonInfo = new JButton();
            this.JButtonInfo.setText(PluginServices.getText((Object)this, (String)"info_transformations"));
            this.JButtonInfo.setMnemonic('I');
            this.JButtonInfo.setEnabled(false);
        }
        return this.JButtonInfo;
    }

    public ICrs getProjection() {
        ICrs crs = null;
        String[] sourceAuthority = this.getSourceAbrev().split(":");
        try {
            crs = new CrsFactory().getCRS(sourceAuthority[0] + ":" + this.getCode(), this.getParams(), null);
        }
        catch (CrsException e) {
            logger.info("Can't create CRS with authority '" + sourceAuthority[0] + "', code " + this.getCode() + " and transformation source params '" + this.getParams() + "'.", (Throwable)e);
        }
        return crs;
    }

    public ICrs getProjectionComplex(String details) {
        String nadFile;
        String[] partes;
        ICrs crs = null;
        RecentTrsPersistence trPersistence = new RecentTrsPersistence();
        TrData[] crsTrDataArray = trPersistence.getArrayOfTrData();
        CompTrData comp = null;
        String sourceTransformation = null;
        String targetTransformation = null;
        for (int iRow = crsTrDataArray.length - 1; iRow >= 0; --iRow) {
            if (!details.equals(crsTrDataArray[iRow].getDetails()) || !(crsTrDataArray[iRow] instanceof CompTrData)) continue;
            comp = (CompTrData)crsTrDataArray[iRow];
            break;
        }
        if (comp.getFirstTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
            TransEPSG epsgParams = new TransEPSG(comp.getFirstTr().getCode(), this.connect, this.getInverseTransformation());
            this.setParamsEPGS(epsgParams.getParamValue());
            sourceTransformation = this.getParams();
        } else if (comp.getFirstTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
            this.setParamsManual(comp.getFirstTr().getDetails());
            sourceTransformation = this.getParams();
        } else if (comp.getFirstTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"NADGR"))) {
            String info = comp.getFirstTr().getDetails();
            partes = info.split("\\(");
            nadFile = partes[0];
            sourceTransformation = "+nadgrids=" + nadFile;
        }
        if (comp.getSecondTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
            TransEPSG epsgParams = new TransEPSG(comp.getSecondTr().getCode(), this.connect, this.getInverseTransformation());
            this.setParamsEPGS(epsgParams.getParamValue());
            targetTransformation = this.getParams();
        } else if (comp.getSecondTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
            this.setParamsManual(comp.getSecondTr().getDetails());
            targetTransformation = this.getParams();
        } else if (comp.getSecondTr().getAuthority().equals(PluginServices.getText((Object)this, (String)"NADGR"))) {
            String info = comp.getSecondTr().getDetails();
            partes = info.split("\\(");
            nadFile = partes[0];
            targetTransformation = "+nadgrids=" + nadFile;
        }
        try {
            crs = new CrsFactory().getCRS(this.getSourceAbrev(), sourceTransformation, targetTransformation);
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create CRS with '" + this.getSourceAbrev() + "' and transformation params source '" + sourceTransformation + " and target'" + targetTransformation + "'.", (Throwable)e);
            return crs;
        }
    }

    public ICrs getProjectionNad(String info) {
        String[] partes = info.split("\\(");
        String nadFile = partes[0];
        int codigoNad = Integer.parseInt(partes[1].substring(0, partes[1].length() - 1).split(":")[1]);
        String[] sourceAuthority = this.getSourceAbrev().split(":");
        String params = "+nadgrids=" + nadFile;
        if (this.getCode() == codigoNad) {
            try {
                this.setNad(false);
                ICrs crs = new CrsFactory().getCRS(sourceAuthority[0] + ":" + this.getCode(), params, null);
                return crs;
            }
            catch (CrsException e) {
                logger.info("Can't create CRS with authority '" + sourceAuthority[0] + "', code " + this.getCode() + " and transformation source params '" + params + " .", (Throwable)e);
                return null;
            }
        }
        this.setNad(true);
        try {
            ICrs crs = new CrsFactory().getCRS(sourceAuthority[0] + ":" + this.getCode(), null, params);
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create CRS with authority '" + sourceAuthority[0] + "', code " + this.getCode() + " and transformation target params '" + params + " .", (Throwable)e);
            return null;
        }
    }

    public void setNad(boolean nadg) {
        this.targetNad = nadg;
    }

    public boolean getNad() {
        return this.targetNad;
    }

    public void setCode(int cod) {
        this.code = cod;
    }

    public int getCode() {
        return this.code;
    }

    public void setWKT(String cad) {
        this.cadWKT = cad;
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public void setParamsManual(String param) {
        this.params = "+towgs84=" + param.substring(1, param.length() - 1) + " ";
    }

    public void setParamsEPGS(String[] values) {
        this.params = "+towgs84=" + values[0];
        for (int i = 1; i < values.length; ++i) {
            this.params = this.params + "," + values[i];
        }
        this.params = this.params + " ";
    }

    public void setParamsNads(String nadfile) {
    }

    public String getParams() {
        return this.params;
    }

    public void setInverseTransformation(boolean inverse) {
        this.inverseTransformation = inverse;
    }

    public boolean getInverseTransformation() {
        return this.inverseTransformation;
    }

    public void setTrCode(int code) {
        this.trCode = code;
    }

    public int getTrCode() {
        return this.trCode;
    }

    public void loadRecents(String source, String target) {
        this.setSourceAbrev(source);
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        RecentTrsPersistence persistence = new RecentTrsPersistence();
        this.trDataArray = persistence.getArrayOfTrData();
        for (int iRow = this.trDataArray.length - 1; iRow >= 0; --iRow) {
            String crsSource = this.trDataArray[iRow].getCrsSource();
            String crsTarget = this.trDataArray[iRow].getCrsTarget();
            if (!source.equals(crsSource) || !target.equals(crsTarget)) continue;
            Object[] row = new Object[]{this.trDataArray[iRow].getAuthority() + ":" + this.trDataArray[iRow].getCode(), this.trDataArray[iRow].getName(), this.trDataArray[iRow].getCrsSource(), this.trDataArray[iRow].getCrsTarget(), this.trDataArray[iRow].getDetails()};
            this.dtm.addRow(row);
        }
        int numr = this.dtm.getRowCount();
        if (numr != 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public void loadRecentsCompuesta(String source) {
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        RecentTrsPersistence persistence = new RecentTrsPersistence();
        this.trDataArray = persistence.getArrayOfTrData();
        for (int iRow = this.trDataArray.length - 1; iRow >= 0; --iRow) {
            if (this.trDataArray[iRow] instanceof CompTrData) continue;
            String crsSource = this.trDataArray[iRow].getCrsSource();
            String crsTarget = this.trDataArray[iRow].getCrsTarget();
            if (!source.equals(crsSource) && !source.equals(crsTarget)) continue;
            Object[] row = new Object[]{this.trDataArray[iRow].getAuthority() + ":" + this.trDataArray[iRow].getCode(), this.trDataArray[iRow].getName(), this.trDataArray[iRow].getCrsSource(), this.trDataArray[iRow].getCrsTarget(), this.trDataArray[iRow].getDetails()};
            this.dtm.addRow(row);
        }
        int numr = this.dtm.getRowCount();
        if (numr != 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public void setSourceAbrev(String source) {
        this.sourceAbrev = source;
    }

    public String getSourceAbrev() {
        return this.sourceAbrev;
    }
}

