/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.installer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.crs.CrsFactory;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.AbstractProvider;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPSGDatabaseInstaller
extends AbstractProvider
implements InstallPackageProvider {
    private static Logger logger = LoggerFactory.getLogger(EPSGDatabaseInstaller.class);
    private int BUFFER = 2048;

    public EPSGDatabaseInstaller(ProviderServices providerServices) {
        super(providerServices);
    }

    public void install(File applicationFolder, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        File i18nFolder = pluginsManager.getApplicationI18nFolder();
        File epsgDatabaseFolder = new File(CrsFactory.getDataBaseFolder(), "EPSG");
        logger.info("Installing package '" + packageInfo.getCode() + "' in '" + epsgDatabaseFolder.getAbsolutePath() + "'.");
        try {
            FileUtils.forceMkdir((File)epsgDatabaseFolder);
            this.decompress(inputStream, epsgDatabaseFolder);
            this.activateThisDataBase(packageInfo);
        }
        catch (Exception e) {
            try {
                logger.warn("Can install package '" + packageInfo.getCode() + "'.", (Throwable)e);
                this.installLater(applicationFolder, inputStream, packageInfo);
            }
            catch (IOException e1) {
                logger.warn("Can install package '" + packageInfo.getCode() + "'.", (Throwable)e1);
                throw new InstallPackageServiceException((Throwable)e1);
            }
        }
    }

    private void activateThisDataBase(PackageInfo packageInfo) {
        String dbentry = "EPSG/" + packageInfo.getCode() + "/EPSG.sql";
        File f = new File(CrsFactory.getDataBaseFolder(), dbentry);
        if (!f.exists()) {
            logger.warn("Can't activate EPSG database, problems locating in '" + f.getAbsolutePath() + "'.");
            return;
        }
        PluginsManager pluginManager = PluginsLocator.getManager();
        PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject pluginProperties = plugin.getPluginProperties();
        pluginProperties.setDynValue("epsgDatabase", (Object)dbentry);
        plugin.savePluginProperties();
    }

    private void decompress(InputStream inputStream, File folder) throws ZipException, IOException, InstallerInfoFileException {
        ZipInputStream zis = null;
        ZipEntry entry = null;
        byte[] data = new byte[this.BUFFER];
        int count = 0;
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        SimpleTaskStatus taskStatus = manager.createDefaultSimpleTaskStatus("Uncompressing...");
        manager.add((TaskStatus)taskStatus);
        String entryName = "(header)";
        try {
            long readed = 0L;
            zis = new ZipInputStream(inputStream);
            while ((entry = zis.getNextEntry()) != null) {
                entryName = FilenameUtils.separatorsToSystem((String)entry.getName());
                taskStatus.message(entryName);
                File file = new File(folder, entryName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
                if (!file.getParentFile().exists()) {
                    FileUtils.forceMkdir((File)file.getParentFile());
                }
                logger.debug("extracting " + file.getAbsolutePath());
                FileOutputStream fos = new FileOutputStream(file);
                while ((count = zis.read(data, 0, this.BUFFER)) != -1) {
                    fos.write(data, 0, count);
                    taskStatus.setCurValue(readed += (long)count);
                }
                fos.flush();
                fos.close();
            }
            zis.close();
        }
        catch (IOException ex) {
            logger.warn("Problems uncompresing 'EPSG database' (last entry '" + entryName + "'.", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.warn("Problems uncompresing 'EPSG database' (last entry '" + entryName + "'.", (Throwable)ex);
            throw ex;
        }
        finally {
            taskStatus.remove();
        }
    }

    public void installLater(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException, IOException {
        logger.warn("installLater is not implementes.");
    }
}

