/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.crs.JCrsExtension;
import org.gvsig.crs.persistence.CrsData;
import org.gvsig.tools.dynobject.DynObject;

public class RecentCRSsPersistence {
    public void addCrsData(CrsData crs) {
        if (crs.getAuthority() == null || crs.getCode() == 0) {
            return;
        }
        List crss = this.getRecentsCrsDatas();
        boolean found = false;
        for (int i = 0; i < crss.size(); ++i) {
            CrsData curcrs = (CrsData)crss.get(i);
            if (!crs.getAuthority().equals(curcrs.getAuthority()) || crs.getCode() != curcrs.getCode()) continue;
            found = true;
            curcrs.setName(crs.getName());
            curcrs.setProperies(crs.getProperies());
            curcrs.updateLastAccess();
        }
        if (!found) {
            if (crss.size() < 20) {
                crss.add(crs);
            } else {
                Collections.sort(crss);
                crss.set(0, crs);
            }
        }
    }

    public CrsData[] getArrayOfCrsData() {
        List crss = this.getRecentsCrsDatas();
        Collections.sort(crss);
        CrsData[] x = crss.toArray(new CrsData[crss.size()]);
        return x;
    }

    private List getRecentsCrsDatas() {
        PluginsManager manager = PluginsLocator.getManager();
        PluginServices plugin = manager.getPlugin(JCrsExtension.class);
        DynObject properties = plugin.getPluginProperties();
        ArrayList crss = (ArrayList)properties.getDynValue("recentCRSs");
        if (crss == null) {
            crss = new ArrayList();
            properties.setDynValue("recentCRSs", crss);
        }
        Iterator iterator = crss.iterator();
        while (iterator.hasNext()) {
            CrsData crs = (CrsData)iterator.next();
            if (crs.getAuthority() != null) continue;
            iterator.remove();
        }
        return crss;
    }
}

