/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.persistence;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class TrData
implements Comparable,
Persistent {
    static final String TRDATA_PERSISTENCE_DEFINITION_NAME = "jCRS_TrData";
    private String authority = null;
    private int code = 0;
    private String name = null;
    private String crsSource = null;
    private String crsTarget = null;
    private String details = null;
    private Date date = null;
    private Properties properties = new Properties();

    public TrData(String authority, int code, String name, String crsSource, String crsTarget, String details) {
        this.authority = authority;
        this.code = code;
        this.name = name;
        this.crsSource = crsSource;
        this.crsTarget = crsTarget;
        this.details = details;
        this.date = new Date();
    }

    public TrData(String authority, int code, String name, String crsSource, String crsTarget, String detalis, Date date) {
        this.authority = authority;
        this.code = code;
        this.name = name;
        this.crsSource = crsSource;
        this.crsTarget = crsTarget;
        this.details = detalis;
        this.date = date;
    }

    public TrData() {
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperies() {
        return this.properties;
    }

    public void setProperies(Properties properies) {
        this.properties = properies;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDate() {
        return this.date;
    }

    public void updateLastAccess() {
        this.date = new Date();
    }

    public int compareTo(Object o) {
        TrData trData = (TrData)o;
        return this.date.compareTo(trData.getDate());
    }

    public String getCrsSource() {
        return this.crsSource;
    }

    public void setCrsSource(String crsSource) {
        this.crsSource = crsSource;
    }

    public String getCrsTarget() {
        return this.crsTarget;
    }

    public void setCrsTarget(String crsTarget) {
        this.crsTarget = crsTarget;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("date", this.date);
        state.set("name", this.name);
        state.set("authority", this.authority);
        state.set("code", Integer.valueOf(this.code));
        state.set("properies", (Map)this.properties);
        state.set("crsSource", this.crsSource);
        state.set("crsTarget", this.crsTarget);
        state.set("details", this.details);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.date = state.getDate("date");
        this.name = state.getString("name");
        this.authority = state.getString("authority");
        this.code = state.getInt("code");
        Map properties = state.getMap("properies");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
        this.crsSource = state.getString("crsSource");
        this.crsTarget = state.getString("crsTarget");
        this.details = state.getString("details");
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(TRDATA_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(TrData.class, TRDATA_PERSISTENCE_DEFINITION_NAME, "jCRS_TrData Persistence definition", null, null);
            definition.addDynFieldDate("date").setMandatory(false);
            definition.addDynFieldString("name").setMandatory(false);
            definition.addDynFieldString("authority").setMandatory(false);
            definition.addDynFieldInt("code").setMandatory(false);
            definition.addDynFieldMap("properies").setClassOfItems(String.class).setMandatory(false);
            definition.addDynFieldString("crsSource").setMandatory(false);
            definition.addDynFieldString("crsTarget").setMandatory(false);
            definition.addDynFieldString("details").setMandatory(false);
        }
    }
}

