/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.layerdatatype;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.tools.algorithm.layerdatatype.LayerDatatypeException;
import org.gvsig.tools.locator.LocatorException;

public class LayerDatatypeProcess
extends DataProcess {
    public static String RASTER_STORE1 = "RasterStore1";
    public static String PATH = "Path";
    public static String FILENAME = "FileName";
    public static String DATATYPE = "Datatype";
    public static String ADJUST_DEC2INT = "AdjustDec2Int";
    public static String ADJUST_BIG2SMALL = "AdjustBig2Small";
    public static String[] DEC2INT_OPTIONS = new String[]{"Trunk", "Round", "Ceil", "Floor"};
    public static String[] BIG2SMALL_OPTIONS = new String[]{"Trunk", "Maxvalue", "NoData"};
    private RasterDataStore store = null;
    private String filename = null;
    private int datatype = 0;
    private int dec2int = 0;
    private int big2smal = 0;
    private NoData byteNoData = null;
    private NoData shortNoData = null;
    private NoData intNoData = null;
    private NoData floatNoData = null;

    public static void registerParameters() {
        LayerDatatypeProcess.registerInputParameter((String)RASTER_STORE1, RasterDataStore.class, (String)"LayerDatatypeProcess");
        LayerDatatypeProcess.registerInputParameter((String)PATH, String.class, (String)"LayerDatatypeProcess");
        LayerDatatypeProcess.registerInputParameter((String)DATATYPE, Integer.class, (String)"LayerDatatypeProcess");
        LayerDatatypeProcess.registerInputParameter((String)ADJUST_DEC2INT, Integer.class, (String)"LayerDatatypeProcess");
        LayerDatatypeProcess.registerInputParameter((String)ADJUST_BIG2SMALL, Integer.class, (String)"LayerDatatypeProcess");
        LayerDatatypeProcess.registerOutputParameter((String)FILENAME, String.class, (String)"LayerDatatypeProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE1) != null ? (RasterDataStore)this.getParam(RASTER_STORE1) : null;
        this.filename = this.getStringParam(PATH);
        this.datatype = (Integer)this.getParam(DATATYPE);
        this.dec2int = (Integer)this.getParam(ADJUST_DEC2INT);
        this.big2smal = (Integer)this.getParam(ADJUST_BIG2SMALL);
        this.byteNoData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), 0);
        this.shortNoData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), 2);
        this.intNoData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), 3);
        this.floatNoData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), 4);
    }

    public void process() throws ProcessInterruptedException {
        this.insertLineLog(Messages.getText((String)"layer_datatype"));
        try {
            this.store = this.store.newNotTiledDataStore();
            if (this.store == null) {
                throw new LayerDatatypeException("intput_not_valid");
            }
            int inDataType = this.store.getDataType()[0];
            BufferParam param = RasterLocator.getManager().getBufferFactory().createBufferParams((int)this.store.getWidth(), (int)this.store.getHeight(), this.store.getBandCount(), this.datatype, true);
            Buffer buf = RasterLocator.getManager().getBufferFactory().createBuffer(param);
            RasterQuery query = RasterLocator.getManager().createQuery();
            query.setAllDrawableBands();
            query.setAreaOfInterest();
            Buffer sourceBuffer = null;
            try {
                sourceBuffer = this.store.query(query);
            }
            catch (QueryException e) {
                throw new LayerDatatypeException("");
            }
            double v = 0.0;
            switch (inDataType) {
                case 0: {
                    for (int row = 0; row < buf.getHeight(); ++row) {
                        for (int col = 0; col < buf.getWidth(); ++col) {
                            for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                                this.writePixelFromByte(row, col, iBand, sourceBuffer.getElemByte(row, col, iBand), buf);
                            }
                        }
                        this.updatePercent(row, buf.getHeight());
                    }
                    break;
                }
                case 2: {
                    for (int row = 0; row < buf.getHeight(); ++row) {
                        for (int col = 0; col < buf.getWidth(); ++col) {
                            for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                                this.writePixelFromShort(row, col, iBand, sourceBuffer.getElemShort(row, col, iBand), buf);
                            }
                        }
                        this.updatePercent(row, buf.getHeight());
                    }
                    break;
                }
                case 3: {
                    for (int row = 0; row < buf.getHeight(); ++row) {
                        for (int col = 0; col < buf.getWidth(); ++col) {
                            for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                                this.writePixelFromInt(row, col, iBand, sourceBuffer.getElemInt(row, col, iBand), buf);
                            }
                        }
                        this.updatePercent(row, buf.getHeight());
                    }
                    break;
                }
                case 4: {
                    for (int row = 0; row < buf.getHeight(); ++row) {
                        for (int col = 0; col < buf.getWidth(); ++col) {
                            for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                                v = this.getDecimalValue(sourceBuffer.getElemFloat(row, col, iBand), inDataType);
                                this.writePixelFromDouble(row, col, iBand, v, buf);
                            }
                        }
                        this.updatePercent(row, buf.getHeight());
                    }
                    break;
                }
                case 5: {
                    for (int row = 0; row < buf.getHeight(); ++row) {
                        for (int col = 0; col < buf.getWidth(); ++col) {
                            for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                                v = this.getDecimalValue(sourceBuffer.getElemDouble(row, col, iBand), inDataType);
                                this.writePixelFromDouble(row, col, iBand, v, buf);
                            }
                        }
                        this.updatePercent(row, buf.getHeight());
                    }
                    break;
                }
            }
            super.exportRaster(this.filename, buf, sourceBuffer.getStore().getCellSize(), sourceBuffer.getStore().getExtent().getULX(), sourceBuffer.getStore().getExtent().getULY(), this.store.getProjection());
            this.addOutputValue(FILENAME, this.filename);
        }
        catch (LayerDatatypeException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("error_changing_the_datatype", (Object)this, (Exception)((Object)e));
        }
        catch (LocatorException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("error_creating_buffer", (Object)this, (Exception)((Object)e));
        }
        catch (BufferCreationException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("error_creating_buffer", (Object)this, (Exception)((Object)e));
        }
    }

    public double getDecimalValue(double value, int inDataType) {
        if (inDataType == 4 || inDataType == 5) {
            switch (this.dec2int) {
                case 0: {
                    return (long)value;
                }
                case 1: {
                    return Math.round(value);
                }
                case 2: {
                    return Math.ceil(value);
                }
                case 3: {
                    return Math.floor(value);
                }
            }
        }
        return value;
    }

    private void writePixelFromByte(int row, int col, int band, byte value, Buffer dst) {
        switch (dst.getDataType()) {
            case 0: {
                dst.setElem(row, col, band, value);
                break;
            }
            case 2: {
                dst.setElem(row, col, band, (short)value);
                break;
            }
            case 3: {
                dst.setElem(row, col, band, (int)value);
                break;
            }
            case 4: {
                dst.setElem(row, col, band, (float)value);
                break;
            }
            case 5: {
                dst.setElem(row, col, band, (double)value);
            }
        }
    }

    private void writePixelFromShort(int row, int col, int band, short value, Buffer dst) {
        switch (dst.getDataType()) {
            case 0: {
                dst.setElem(row, col, band, (byte)value);
                if (value <= 127) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, (byte)127);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Byte)this.byteNoData.getValue()).byteValue());
                    }
                }
                break;
            }
            case 2: {
                dst.setElem(row, col, band, value);
                break;
            }
            case 3: {
                dst.setElem(row, col, band, (int)value);
                break;
            }
            case 4: {
                dst.setElem(row, col, band, (float)value);
                break;
            }
            case 5: {
                dst.setElem(row, col, band, (double)value);
            }
        }
    }

    private void writePixelFromInt(int row, int col, int band, int value, Buffer dst) {
        switch (dst.getDataType()) {
            case 0: {
                dst.setElem(row, col, band, (byte)value);
                if (value <= 127) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, (byte)127);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Byte)this.byteNoData.getValue()).byteValue());
                    }
                }
                break;
            }
            case 2: {
                dst.setElem(row, col, band, (short)value);
                if (value <= Short.MAX_VALUE) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, (short)Short.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Short)this.shortNoData.getValue()).shortValue());
                    }
                }
                break;
            }
            case 3: {
                dst.setElem(row, col, band, value);
                break;
            }
            case 4: {
                dst.setElem(row, col, band, (float)value);
                break;
            }
            case 5: {
                dst.setElem(row, col, band, (double)value);
            }
        }
    }

    private void writePixelFromDouble(int row, int col, int band, double value, Buffer dst) {
        switch (dst.getDataType()) {
            case 0: {
                dst.setElem(row, col, band, (byte)value);
                if (!(value > 127.0)) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, (byte)127);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Byte)this.byteNoData.getValue()).byteValue());
                    }
                }
                break;
            }
            case 2: {
                dst.setElem(row, col, band, (short)value);
                if (!(value > 32767.0)) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, (short)Short.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Short)this.shortNoData.getValue()).shortValue());
                    }
                }
                break;
            }
            case 3: {
                dst.setElem(row, col, band, (int)value);
                if (!(value > 2.147483647E9)) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, Integer.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Integer)this.intNoData.getValue()).intValue());
                    }
                }
                break;
            }
            case 4: {
                dst.setElem(row, col, band, (float)value);
                if (!(value > 3.4028234663852886E38)) break;
                switch (this.big2smal) {
                    case 1: {
                        dst.setElem(row, col, band, Float.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        dst.setElem(row, col, band, ((Float)this.floatNoData.getValue()).floatValue());
                    }
                }
                break;
            }
            case 5: {
                dst.setElem(row, col, band, value);
            }
        }
    }

    public String getTitle() {
        return Messages.getText((String)"layer_datatype");
    }
}

