/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.io;

import com.github.miachm.SODS.io.Compressor;
import com.github.miachm.SODS.spreadsheet.Range;
import com.github.miachm.SODS.spreadsheet.Sheet;
import com.github.miachm.SODS.spreadsheet.SpreadSheet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OdsWritter {
    private SpreadSheet spread;
    private Compressor out;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private final String MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";

    private OdsWritter(OutputStream o, SpreadSheet spread) throws IOException {
        this.spread = spread;
        this.out = new Compressor(o);
        this.dbf.setNamespaceAware(true);
    }

    public static void save(OutputStream out, SpreadSheet spread) throws IOException {
        new OdsWritter(out, spread).save();
    }

    private void save() throws IOException {
        this.writeManifest();
        this.writeMymeType();
        this.writeSpreadsheet();
        this.out.close();
    }

    private void writeManifest() {
        Element e = null;
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            String namespace = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
            Element rootEle = dom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:manifest");
            rootEle.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:version", "1.2");
            e = dom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:file-entry");
            e.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:full-path", "/");
            e.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:version", "1.2");
            e.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:media-type", "application/vnd.oasis.opendocument.spreadsheet");
            rootEle.appendChild(e);
            e = dom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:file-entry");
            e.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:full-path", "content.xml");
            e.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:media-type", "text/xml");
            rootEle.appendChild(e);
            dom.appendChild(rootEle);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "no");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                tr.transform(new DOMSource(dom), new StreamResult(o));
                o.close();
                this.out.addEntry(o.toByteArray(), "META-INF/manifest.xml");
            }
            catch (TransformerException te) {
                System.err.println(te.getMessage());
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.err.println("UsersXML: Error trying to instantiate DocumentBuilder " + pce);
        }
    }

    private void writeMymeType() throws IOException {
        this.out.addEntry("application/vnd.oasis.opendocument.spreadsheet".getBytes(), "mimetype");
    }

    private void writeSpreadsheet() {
        Element e = null;
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            String office = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
            String table_namespace = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
            String text_namespace = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
            Element rootEle = dom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "office:document-content");
            rootEle.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "office:version", "1.2");
            rootEle.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            rootEle.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            e = dom.createElement("office:body");
            Element spreadsheet = dom.createElement("office:spreadsheet");
            e = dom.createElement("office:body");
            e.appendChild(spreadsheet);
            rootEle.appendChild(e);
            dom.appendChild(rootEle);
            for (Sheet sheet : this.spread.getSheets()) {
                int i;
                Element table = dom.createElement("table:table");
                table.setAttribute("table:name", sheet.getName());
                for (i = 0; i < sheet.getMaxColumns(); ++i) {
                    Element column = dom.createElementNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table:table-column");
                    table.appendChild(column);
                }
                for (i = 0; i < sheet.getMaxRows(); ++i) {
                    Element row = dom.createElement("table:table-row");
                    Range r = sheet.getRange(i, 0, 1, sheet.getMaxColumns());
                    for (int j = 0; j < sheet.getMaxColumns(); ++j) {
                        Range range = r.getCell(0, j);
                        Object v = range.getValue();
                        String formula = range.getFormula();
                        Element cell = dom.createElement("table:table-cell");
                        if (formula != null) {
                            cell.setAttribute("table:formula", formula);
                        }
                        if (v != null) {
                            String valueType = this.getValueType(v);
                            cell.setAttribute("office:value-type", valueType);
                            Element value = dom.createElement("text:p");
                            value.setTextContent("" + v);
                            if (!valueType.equals("string")) {
                                cell.setAttribute("office:value", "" + v);
                            }
                            cell.appendChild(value);
                        }
                        row.appendChild(cell);
                    }
                    table.appendChild(row);
                }
                spreadsheet.appendChild(table);
            }
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "no");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                tr.transform(new DOMSource(dom), new StreamResult(o));
                o.close();
                this.out.addEntry(o.toByteArray(), "content.xml");
            }
            catch (IOException | TransformerException te) {
                System.err.println(te.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.err.println("UsersXML: Error trying to instantiate DocumentBuilder " + pce);
        }
    }

    private String getValueType(Object v) {
        if (v instanceof Integer || v instanceof Float || v instanceof Double) {
            return "float";
        }
        return "string";
    }
}

