/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cresques.Messages;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.gui.panels.crs.ISelectCrsPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ProjChooserPanel
extends CRSSelectPanel {
    private IProjection curProj = null;
    private JLabel jLblProj = null;
    private JLabel jLblProjName = null;
    private JButton jBtnChangeProj = null;
    private final JPanel jPanelProj = null;
    private boolean okPressed = false;

    public ProjChooserPanel(IProjection proj) {
        super(proj);
        this.setCurProj(proj);
        this.initialize();
    }

    private void initialize() {
        GridLayout gl = new GridLayout(1, 2);
        this.setLayout(gl);
        this.add(this.getJLblProjName());
        JPanel secondHalf = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 0;
        secondHalf.add((Component)this.getJLblProj(), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 1;
        secondHalf.add((Component)this.getJBtnChangeProj(), c);
        this.add(secondHalf);
        this.initBtnChangeProj();
    }

    private void initBtnChangeProj() {
        this.getJBtnChangeProj().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjChooserPanel.this.okPressed = false;
                ISelectCrsPanel csSelect = CRSSelectPanel.getUIFactory().getSelectCrsPanel(ProjChooserPanel.this.curProj, true);
                ToolsSwingLocator.getWindowManager().showWindow((JComponent)((Object)csSelect), Messages.getText((String)"selecciona_sistema_de_referencia"), WindowManager.MODE.DIALOG);
                if (csSelect.isOkPressed()) {
                    ProjChooserPanel.this.curProj = csSelect.getProjection();
                    ProjChooserPanel.this.jLblProj.setText(ProjChooserPanel.this.curProj.getAbrev());
                    ProjChooserPanel.this.okPressed = true;
                    if (ProjChooserPanel.this.actionListener != null) {
                        ProjChooserPanel.this.actionListener.actionPerformed(e);
                    }
                }
            }
        });
    }

    public JLabel getJLblProjName() {
        if (this.jLblProjName == null) {
            this.jLblProjName = new JLabel("Proyeccion actual");
            this.jLblProjName.setText(Messages.getText((String)"__proyeccion_actual"));
        }
        return this.jLblProjName;
    }

    @Override
    public JLabel getJLabel() {
        return this.getJLblProjName();
    }

    public JLabel getJLblProj() {
        if (this.jLblProj == null) {
            this.jLblProj = new JLabel();
            this.jLblProj.setAlignmentX(0.5f);
            if (this.curProj != null) {
                this.jLblProj.setText(this.curProj.getAbrev());
            }
        }
        return this.jLblProj;
    }

    public void addBtnChangeProjActionListener(ActionListener al) {
        this.jBtnChangeProj.addActionListener(al);
    }

    @Override
    public JButton getJBtnChangeProj() {
        if (this.jBtnChangeProj == null) {
            this.jBtnChangeProj = new JButton();
            this.jBtnChangeProj.setText("...");
        }
        return this.jBtnChangeProj;
    }

    @Override
    public IProjection getCurProj() {
        return this.curProj;
    }

    @Override
    public void setCurProj(IProjection curProj) {
        this.curProj = curProj;
    }

    @Override
    public boolean isOkPressed() {
        return this.okPressed;
    }
}

