/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.multifile.app.MainDialogActions;
import org.gvsig.raster.multifile.app.MultiFileCreatorTocMenuEntry;
import org.gvsig.raster.multifile.app.panel.BandSelectorPanel;
import org.gvsig.raster.multifile.app.panel.MainWindow;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class MultifileClientExtension
extends Extension
implements ActionListener {
    private CreateNewLayerPanel newLayerPanel = null;
    private MainWindow layerNamewindow = null;
    private MainWindow bandSelectorwindow = null;
    private MainDialogActions actions = null;

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("AplicationPreferences");
        point = extensionPoints.get("RasterSEPropertiesDialog");
        point.append("Bandas", "", BandSelectorPanel.class);
        point = extensionPoints.add("GenericToolBarMenu");
        point.append("Multifile", "", (ExtensionBuilder)MultiFileCreatorTocMenuEntry.getSingleton());
        MultiFileCreatorTocMenuEntry.setExtension(this);
        if (!Messages.hasLocales()) {
            Messages.addLocale((Locale)Locale.getDefault());
        }
        Messages.addResourceFamily((String)"org.gvsig.raster.multifile.app.i18n.text", (ClassLoader)MultifileClientExtension.class.getClassLoader(), (String)MultifileClientExtension.class.getClass().getName());
        this.initilizeIcons();
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareTo("MultifileCreator") == 0) {
            this.layerNamewindow = new MainWindow((JComponent)this.getNewLayerPanel(), Messages.getText((String)"select_output_file"), 300, 150, this);
            PluginServices.getMDIManager().addCentredWindow((IWindow)this.layerNamewindow);
        }
    }

    private void initilizeIcons() {
        IconThemeHelper.registerIcon(null, (String)"multifile-icon", (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public CreateNewLayerPanel getNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel();
        }
        return this.newLayerPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.layerNamewindow.getButtonsPanel().getButton(1)) {
            String file = this.getNewLayerPanel().getFileSelected();
            String folder = this.getNewLayerPanel().getDirectorySelected();
            BandSelectorPanel panel = new BandSelectorPanel(1);
            panel.getListener().setDestination(file, folder);
            this.actions = new MainDialogActions(panel, file, folder);
            this.bandSelectorwindow = new MainWindow((JComponent)((Object)panel), Messages.getText((String)"add_files"), 500, 400, this, true);
            PluginServices.getMDIManager().addCentredWindow((IWindow)this.bandSelectorwindow);
        }
        if (e.getSource() == this.bandSelectorwindow.getButtonsPanel().getButton(100)) {
            this.actions.loadLayer();
        }
        if (e.getSource() == this.bandSelectorwindow.getButtonsPanel().getButton(101)) {
            this.actions.buildOneLayer();
        }
    }
}

