/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.multifile.app.panel.BandSelectorPanel;
import org.gvsig.raster.multifile.app.panel.DriverFileFilter;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileFormat;
import org.gvsig.raster.multifile.io.MultiFileProvider;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBandSelectorListener
implements ActionListener,
ButtonsPanelListener {
    protected Logger log = LoggerFactory.getLogger(AbstractBandSelectorListener.class);
    protected BandSelectorPanel bandSetupPanel = null;
    protected boolean enabled = true;
    protected String file = null;
    protected String folder = null;

    public AbstractBandSelectorListener(BandSelectorPanel bs) {
        this.bandSetupPanel = bs;
        bs.getFileList().getJButtonAdd().addActionListener(this);
        bs.getFileList().getJButtonRemove().addActionListener(this);
        bs.getNumBandSelectorCombo().addActionListener(this);
    }

    public void setDestination(String file, String folder) {
        this.file = file;
        this.folder = folder;
    }

    public void setEnabledPanelAction(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract void setNewBandsPositionInRendering();

    public abstract RasterDataStore getResult();

    public abstract void apply();

    public abstract void addFileBand();

    public abstract void delFileBand();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bandSetupPanel.getFileList().getJButtonAdd())) {
            this.addFileBand();
        }
        if (e.getSource().equals(this.bandSetupPanel.getFileList().getJButtonRemove())) {
            this.delFileBand();
        }
    }

    protected JFileChooser createJFileChooser() {
        JFileChooser fileChooser = new JFileChooser("OPEN_LAYER_FILE_CHOOSER_ID", JFileChooser.getLastPath((String)"OPEN_LAYER_FILE_CHOOSER_ID", null));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter((FileFilter)new DriverFileFilter());
        return fileChooser;
    }

    protected boolean checkStoresCompatibility(RasterDataStore mainRasterStore, List<File> fileList) {
        for (int i = fileList.size() - 1; i >= 0; --i) {
            try {
                if (this.checkNewFile(mainRasterStore, fileList.get(i).getAbsolutePath())) continue;
                JOptionPane.showMessageDialog(null, Messages.getText((String)"extents_no_coincidentes") + " " + fileList.get(i).getAbsolutePath(), "", 0);
                fileList.remove(i);
                continue;
            }
            catch (Exception e) {
                this.log.debug("Problems check the bounding boxes", (Throwable)e);
            }
        }
        return !mainRasterStore.isTiled() || RasterSwingLibrary.messageBoxYesOrNot((String)Messages.getText((String)"store_tiled"), (Object)this);
    }

    protected MultiFileProvider createMultiFileProvider(String layerName, String path) {
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            MultiFileDataParameters newParamsMultifile = (MultiFileDataParameters)dataManager.createStoreParameters(MultiFileProvider.NAME);
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            File fileURI = new File(path + layerName + ".mff");
            File rmfURI = new File(path + layerName + ".rmf");
            int counter = 0;
            while (fileURI.exists() || rmfURI.exists()) {
                fileURI = new File(path + layerName + "_" + counter + ".mff");
                rmfURI = new File(path + layerName + "_" + counter + ".rmf");
                ++counter;
            }
            if (counter > 0) {
                layerName = layerName + "_" + counter;
            }
            newParamsMultifile.setURI(fileURI.toURI());
            return (MultiFileProvider)dataManager.createProvider(null, (DataStoreParameters)newParamsMultifile);
        }
        catch (Exception exc) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"addband_error"), (Object)this.bandSetupPanel, (Exception)exc);
            return null;
        }
    }

    protected boolean isCorrectAssignedBand(int r, int g, int b, int a) {
        if (r == g && r == b && r >= 0) {
            return r != a;
        }
        int[] list = new int[]{r, g, b, a};
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                if (i == j || list[i] != list[j] || list[i] <= -1) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkNewFile(RasterDataStore oldStore, String file) throws LocatorException, NotSupportedExtensionException, RasterDriverException, CloseException {
        Rectangle2D extentOrigin = oldStore.getExtent().toRectangle2D();
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters storeParameters = provServ.createParameters(file);
        storeParameters.setSRS(oldStore.getProjection());
        RasterDataStore dataStore = RasterLocator.getManager().getProviderServices().open((DataStoreParameters)storeParameters);
        Extent extentNewFile = dataStore.getExtent();
        double widthNewFile = extentNewFile.getMax().getX() - extentNewFile.getMin().getX();
        double heightNewFile = extentNewFile.getMax().getY() - extentNewFile.getMin().getY();
        if (widthNewFile - extentOrigin.getWidth() > 1.0 || widthNewFile - extentOrigin.getWidth() < -1.0 || heightNewFile - extentOrigin.getHeight() > 1.0 || heightNewFile - extentOrigin.getHeight() < -1.0) {
            return false;
        }
        if (extentNewFile.getMax().getX() - extentNewFile.getMin().getX() != extentOrigin.getWidth() || extentNewFile.getMax().getY() - extentNewFile.getMin().getY() != extentOrigin.getHeight()) {
            return false;
        }
        dataStore.close();
        return true;
    }

    protected String saveMultiFileLayer(String layerName, String file, ArrayList<File> uriList) throws IOException {
        String path = file.substring(0, file.lastIndexOf(File.separator) + 1);
        path = path + layerName + ".mff";
        MultiFileFormat format = new MultiFileFormat();
        for (int i = 0; i < uriList.size(); ++i) {
            format.addFile(uriList.get(i));
        }
        format.setName(layerName);
        format.write(path);
        return path;
    }
}

