/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.ExecuteTopologyRuleActionException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleAction;

public class LineMustBeCoveredByBoundaryOfPolygonRule
extends AbstractTopologyRule {
    private static final String MANY_CROSSING_POLYGONS = "Many crossing polygons";
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public LineMustBeCoveredByBoundaryOfPolygonRule() {
    }

    public LineMustBeCoveredByBoundaryOfPolygonRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
        this.addAction((TopologyRuleAction)new SubtractAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        Object set = null;
        try {
            int maxCrossingPolygons = 100;
            FeatureStore store2 = this.getDataSet2().getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            Geometry line = feature1.getDefaultGeometry();
            TopologyDataSet theDataSet2 = this.getDataSet2();
            double theTolerance = this.getTolerance();
            int subtype = store2.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getSubType();
            MultiPolygon multipolygon = GeometryLocator.getGeometryManager().createMultiPolygon(subtype);
            int count = 0;
            if (theDataSet2.getSpatialIndex() != null) {
                Iterable feats = theDataSet2.query(line);
                for (FeatureReference featureReference : feats) {
                    Feature feature2 = featureReference.getFeature();
                    Geometry otherPolygon = feature2.getDefaultGeometry();
                    if (otherPolygon == null) continue;
                    Geometry boundary = otherPolygon.boundary();
                    if (boundary != null && theTolerance != 0.0) {
                        boundary = boundary.buffer(theTolerance);
                    }
                    if (boundary == null || !boundary.intersects(line)) continue;
                    multipolygon.addPrimitives(otherPolygon);
                    if (count > maxCrossingPolygons) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), line, line, feature1.getReference(), null, -1, -1, false, i18n.getTranslation("_Line_crosses_too_many_polygons"), MANY_CROSSING_POLYGONS);
                        return;
                    }
                    ++count;
                }
            } else {
                if (theTolerance == 0.0) {
                    this.expression.setPhrase(this.expressionBuilder.and((ExpressionBuilder.Value)this.expressionBuilder.ST_Intersects((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.envelope(line.getEnvelope())), (ExpressionBuilder.Value)this.expressionBuilder.ST_Intersects((ExpressionBuilder.Value)this.expressionBuilder.function("ST_Boundary", new ExpressionBuilder.Value[]{this.expressionBuilder.column(this.geomName)}), (ExpressionBuilder.Value)this.expressionBuilder.geometry(line))).toString());
                } else {
                    this.expression.setPhrase(this.expressionBuilder.and((ExpressionBuilder.Value)this.expressionBuilder.ST_Intersects((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.envelope(line.buffer(theTolerance).getEnvelope())), (ExpressionBuilder.Value)this.expressionBuilder.ST_Intersects((ExpressionBuilder.Value)this.expressionBuilder.ST_Buffer((ExpressionBuilder.Value)this.expressionBuilder.function("ST_Boundary", new ExpressionBuilder.Value[]{this.expressionBuilder.column(this.geomName)}), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)theTolerance)), (ExpressionBuilder.Value)this.expressionBuilder.geometry(line))).toString());
                }
                FeatureSet features = store2.getFeatureSet(this.expression);
                for (Feature feature2 : features) {
                    Geometry otherPolygon;
                    if (feature2 == null || (otherPolygon = feature2.getDefaultGeometry()) == null) continue;
                    multipolygon.addPrimitives(otherPolygon);
                    if (count > maxCrossingPolygons) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), line, line, feature1.getReference(), null, -1, -1, false, i18n.getTranslation("_Line_crosses_too_many_polygons"), MANY_CROSSING_POLYGONS);
                        return;
                    }
                    ++count;
                }
            }
            if (multipolygon.isEmpty()) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), line, line, feature1.getReference(), null, false, i18n.getTranslation("_Line_is_not_covered_by_boundary_of_any_polygon"));
                return;
            }
            Geometry boundary = multipolygon.boundary();
            if (boundary != null) {
                Geometry difference;
                if (theTolerance != 0.0) {
                    boundary = boundary.buffer(theTolerance);
                }
                if ((difference = line.difference(boundary)) != null) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), line, difference, feature1.getReference(), null, false, i18n.getTranslation("_Line_is_not_covered_by_boundary_of_the_polygon"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }

    private class SubtractAction
    extends AbstractTopologyRuleAction {
        public SubtractAction() {
            super("LineMustBeCoveredByBoundaryOfPolygon", "Subtract", "Subtract", "The Subtract fix removes line segments that are not coincident with the boundary of polygon features. If the line feature does not share any segments in common with the boundary of a polygon feature, the feature will be deleted. This fix can be applied to one or more Must Be Covered By Boundary Of errors.");
        }

        public int execute(TopologyRule rule, TopologyReportLine reportLine, DynObject parameters) {
            block12: {
                try {
                    Geometry intersection;
                    if (StringUtils.endsWithIgnoreCase((CharSequence)reportLine.getData(), (CharSequence)LineMustBeCoveredByBoundaryOfPolygonRule.MANY_CROSSING_POLYGONS)) {
                        if (rule.getPlan().canUseUI()) {
                            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                            I18nManager i18n = ToolsLocator.getI18nManager();
                            dialogs.messageDialog(i18n.getTranslation("The_solution_cannot_be_automated_because_the_line_crosses_too_many_polygons"), i18n.getTranslation("Subtract"), 1);
                        }
                        return 1;
                    }
                    Geometry errorGeom = reportLine.getError();
                    TopologyDataSet dataSet = rule.getDataSet1();
                    FeatureReference featRef1 = reportLine.getFeature1();
                    Feature feat1 = featRef1.getFeature();
                    Geometry line = feat1.getDefaultGeometry();
                    if (line == errorGeom) {
                        dataSet.delete(featRef1);
                        return 0;
                    }
                    TopologyDataSet theDataSet2 = rule.getDataSet2();
                    FeatureStore store2 = theDataSet2.getFeatureStore();
                    int subtype = store2.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getSubType();
                    MultiPolygon multipolygon = GeometryLocator.getGeometryManager().createMultiPolygon(subtype);
                    if (theDataSet2.getSpatialIndex() != null) {
                        Iterable feats = theDataSet2.query(line);
                        for (FeatureReference featureReference : feats) {
                            Geometry boundary;
                            Feature feature2 = featureReference.getFeature();
                            Geometry otherPolygon = feature2.getDefaultGeometry();
                            if (otherPolygon == null || (boundary = otherPolygon.boundary()) == null || !boundary.intersects(line)) continue;
                            multipolygon.addPrimitives(otherPolygon);
                        }
                    } else {
                        Expression theExpression = ExpressionUtils.createExpression();
                        GeometryExpressionBuilder theExpressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                        String theGeomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
                        theExpression.setPhrase(theExpressionBuilder.ifnull((ExpressionBuilder.Value)theExpressionBuilder.column(theGeomName), (ExpressionBuilder.Value)theExpressionBuilder.constant((Object)false), (ExpressionBuilder.Value)theExpressionBuilder.ST_Intersects((ExpressionBuilder.Value)theExpressionBuilder.function("ST_Boundary", new ExpressionBuilder.Value[]{theExpressionBuilder.column(theGeomName)}), (ExpressionBuilder.Value)theExpressionBuilder.geometry(line))).toString());
                        FeatureSet features = store2.getFeatureSet(theExpression);
                        for (Feature feature2 : features) {
                            Geometry otherPolygon;
                            if (feature2 == null || (otherPolygon = feature2.getDefaultGeometry()) == null) continue;
                            multipolygon.addPrimitives(otherPolygon);
                        }
                    }
                    if (multipolygon.getPrimitivesNumber() == 0) {
                        dataSet.delete(featRef1);
                        return 0;
                    }
                    Geometry boundary = multipolygon.boundary();
                    if (boundary == null || (intersection = line.intersection(boundary)) == null) break block12;
                    EditableFeature editFeat = feat1.getEditable();
                    if (intersection instanceof Complex) {
                        intersection = ((Complex)intersection).createAggregate(21, g -> GeometryUtils.isSubtype((int)8, (int)g.getGeometryType().getType()) || GeometryUtils.isSubtype((int)2, (int)g.getGeometryType().getType()));
                    }
                    if (GeometryUtils.isSubtype((int)8, (int)intersection.getGeometryType().getType()) || GeometryUtils.isSubtype((int)2, (int)intersection.getGeometryType().getType())) {
                        editFeat.setDefaultGeometry(intersection);
                        dataSet.update(editFeat);
                        break block12;
                    }
                    dataSet.delete(featRef1);
                    return 0;
                }
                catch (Exception ex) {
                    throw new ExecuteTopologyRuleActionException(ex);
                }
            }
            return 0;
        }
    }
}

