/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.ExecuteTopologyRuleActionException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleAction;

public class LineMustBeLargerThanToleranceRule
extends AbstractTopologyRule {
    public LineMustBeLargerThanToleranceRule() {
    }

    public LineMustBeLargerThanToleranceRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
        this.addAction((TopologyRuleAction)new DeleteAction());
    }

    public void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature) throws Exception {
        Geometry geom = feature.getDefaultGeometry();
        if (geom.perimeter() < this.getTolerance()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            report.addLine((TopologyRule)this, this.getDataSet1(), null, geom, null, feature.getReference(), null, false, i18n.getTranslation("_The_length_of_the_line_is_less_than_the_specified_tolerance"));
        }
    }

    private class DeleteAction
    extends AbstractTopologyRuleAction {
        public DeleteAction() {
            super("LineMustBeLargerThanTolerance", "delete", "Delete", "Removes line features that would collapse during the validate process based on the topology's tolerance.");
        }

        public int execute(TopologyRule rule, TopologyReportLine line, DynObject parameters) {
            try {
                TopologyDataSet dataset = line.getDataSet1();
                dataset.delete(line.getFeature1());
                return 0;
            }
            catch (Exception ex) {
                throw new ExecuteTopologyRuleActionException(ex);
            }
        }
    }
}

