/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.BinaryFunction;
import com.github.tbekolay.jnumeric.PyMultiarray;
import org.python.core.Py;
import org.python.core.PyObject;

final class BitwiseXor
extends BinaryFunction {
    BitwiseXor() {
    }

    @Override
    final PyMultiarray identity() {
        return BinaryFunction.one;
    }

    @Override
    final void accumulate(Object aData, int sa, int dim, int dsa, Object rData, int sr, int rDim, int dsr, char type) {
        int maxSa = sa + dim * dsa;
        switch (type) {
            case '1': {
                byte[] rData1 = (byte[])rData;
                byte[] aData1 = (byte[])aData;
                byte last1 = aData1[sa];
                while (sa != maxSa) {
                    rData1[sr] = last1 = (byte)(last1 ^ aData1[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 's': {
                short[] rDatas = (short[])rData;
                short[] aDatas = (short[])aData;
                short lasts = aDatas[sa];
                while (sa != maxSa) {
                    rDatas[sr] = lasts = (short)(lasts ^ aDatas[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'i': {
                int[] rDatai = (int[])rData;
                int[] aDatai = (int[])aData;
                int lasti = 1;
                while (sa != maxSa) {
                    rDatai[sr] = lasti ^= aDatai[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'l': {
                long[] rDatal = (long[])rData;
                long[] aDatal = (long[])aData;
                long lastl = 1L;
                while (sa != maxSa) {
                    rDatal[sr] = lastl ^= aDatal[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'O': {
                super.accumulate(aData, sa, dim, dsa, rData, sr, rDim, dsr, type);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecd must be in [zcbhilfdO]");
            }
        }
    }

    @Override
    public final PyObject call(PyObject po1, PyObject po2) {
        return PyMultiarray.asarray(po1).__xor__((PyObject)PyMultiarray.asarray(po2));
    }

    @Override
    final PyObject call(PyMultiarray a, PyMultiarray b, PyMultiarray result) {
        return a.__xor__((PyObject)b, result);
    }
}

