/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;

final class Sin
extends UnaryFunction {
    Sin() {
    }

    @Override
    String docString() {
        return "sin(a [,r]) returns sin(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.sin(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            double eim = Math.exp(im);
            double cosre = Math.cos(re);
            double sinre = Math.sin(re);
            Array.setDouble(a.data, i, 0.5 * sinre * (eim + 1.0 / eim));
            Array.setDouble(a.data, i + 1, 0.5 * cosre * (eim - 1.0 / eim));
        }
        return a;
    }
}

