/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.spi;

import java.net.URL;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.RuleResourceLoaderUtils;
import org.json.JSONObject;

public abstract class AbstractTopologyRuleAction
implements TopologyRuleAction {
    protected String idRule;
    protected String idAction;
    protected String name;
    protected String shortDescription;

    protected AbstractTopologyRuleAction(String idRule) {
        this.idRule = idRule;
        this.idAction = null;
        this.name = null;
        this.shortDescription = null;
    }

    protected AbstractTopologyRuleAction(String idRule, String idAction, String name, String shortDescription) {
        this.idRule = idRule;
        this.idAction = idAction;
        this.name = name;
        this.shortDescription = shortDescription;
        this.load_from_resource();
    }

    @Override
    public String getId() {
        return this.idAction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public TopologyRuleFactory getRuleFactory() {
        TopologyRuleFactory f = TopologyLocator.getTopologyManager().getRulefactory(this.idRule);
        return f;
    }

    @Override
    public boolean hasParameters() {
        return false;
    }

    @Override
    public DynObject createParameters() {
        return null;
    }

    private void load_from_resource() {
        URL url = RuleResourceLoaderUtils.getRuleURL(this.idRule);
        JSONObject rule = RuleResourceLoaderUtils.getRule(url);
        this.load_from_resource(url, rule);
    }

    protected void load_from_resource(URL jsonUrl, JSONObject rule) {
        if (rule == null) {
            return;
        }
        JSONObject action = RuleResourceLoaderUtils.getAction(rule, this.idAction);
        if (action.has("name")) {
            this.name = action.getString("name");
        }
        if (action.has("description")) {
            this.shortDescription = RuleResourceLoaderUtils.getDescription(jsonUrl, action);
        }
    }
}

