/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.spi;

import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.RuleResourceLoaderUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopologyRuleFactory
implements TopologyRuleFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTopologyRuleFactory.class);
    private final String id;
    protected String name;
    protected String description;
    private final List<Integer> geometryTypeDataSet1;
    private final List<Integer> geometryTypeDataSet2;

    protected AbstractTopologyRuleFactory(String id, String name, String description, List<Integer> geometryTypeDataSet1, List<Integer> geometryTypeDataSet2) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.geometryTypeDataSet1 = geometryTypeDataSet1;
        this.geometryTypeDataSet2 = geometryTypeDataSet2;
        this.load_from_resource();
    }

    protected AbstractTopologyRuleFactory(String id, String name, String description, List<Integer> geometryTypeDataSet1) {
        this(id, name, description, geometryTypeDataSet1, null);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Integer> getGeometryTypeDataSet1() {
        return this.geometryTypeDataSet1;
    }

    @Override
    public List<Integer> getGeometryTypeDataSet2() {
        return this.geometryTypeDataSet2;
    }

    @Override
    public boolean hasSecondaryDataSet() {
        return this.geometryTypeDataSet2 != null && !this.geometryTypeDataSet2.isEmpty();
    }

    @Override
    public boolean canApplyToDataSet(TopologyDataSet dataSet) {
        if (this.geometryTypeDataSet1 == null) {
            return true;
        }
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        for (Integer geometryType : this.geometryTypeDataSet1) {
            boolean canApply = geomManager.isSubtype(geometryType.intValue(), dataSet.getGeometryType());
            if (!canApply) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyToSecondaryDataSet(TopologyDataSet dataSet) {
        if (!this.hasSecondaryDataSet()) {
            return false;
        }
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        for (Integer geometryType : this.geometryTypeDataSet2) {
            boolean canApply = geomManager.isSubtype(geometryType.intValue(), dataSet.getGeometryType());
            if (!canApply) continue;
            return true;
        }
        return false;
    }

    private void load_from_resource() {
        URL url = RuleResourceLoaderUtils.getRuleURL(this.id);
        this.load_from_resource(url);
    }

    protected void load_from_resource(URL url) {
        JSONObject json = RuleResourceLoaderUtils.getRule(url);
        this.load_from_resource(url, json);
    }

    protected void load_from_resource(URL jsonUrl, JSONObject json) {
        if (json == null) {
            return;
        }
        if (json.has("name")) {
            this.name = json.getString("name");
        }
        if (json.has("description")) {
            this.description = RuleResourceLoaderUtils.getDescription(jsonUrl, json);
        }
    }

    @Override
    public DynObject createRuleParameters() {
        return null;
    }

    @Override
    public boolean hasRuleParameters() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTopologyRuleFactory other = (AbstractTopologyRuleFactory)obj;
        return Objects.equals(this.name, other.name);
    }
}

