/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.spi;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleResourceLoaderUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleResourceLoaderUtils.class);

    public static URL getRuleURL(String idRule) {
        String lang = Locale.getDefault().getLanguage();
        URL url = RuleResourceLoaderUtils.class.getResource("/org/gvsig/topology/rules/" + lang + "/" + idRule + ".json");
        if (url == null && (url = RuleResourceLoaderUtils.class.getResource("/org/gvsig/topology/rules/en/" + idRule + ".json")) == null) {
            return null;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getRule(URL url) {
        JSONObject json;
        if (url == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            json = new JSONObject(StringUtils.join((Iterable)lines, (String)"\n"));
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load resource from json file '" + url.toString() + "'.", (Throwable)ex);
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return json;
    }

    public static JSONObject getRule(String idRuleOrPathname) {
        if (idRuleOrPathname == null) {
            return null;
        }
        if (idRuleOrPathname.endsWith(".json")) {
            return RuleResourceLoaderUtils.getRule(new File(idRuleOrPathname));
        }
        URL url = RuleResourceLoaderUtils.getRuleURL(idRuleOrPathname);
        if (url == null) {
            return null;
        }
        return RuleResourceLoaderUtils.getRule(url);
    }

    public static JSONObject getRule(File jsonfile) {
        if (jsonfile == null || !jsonfile.exists()) {
            return null;
        }
        try {
            return RuleResourceLoaderUtils.getRule(jsonfile.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Can't load resource from json file '" + jsonfile.toString() + "'.", (Throwable)ex);
            return null;
        }
    }

    public static String getDescription(URL jsonUrl, JSONObject json) {
        String description = null;
        if (json.has("description")) {
            Object x = json.get("description");
            if (x instanceof String) {
                description = (String)x;
            } else if (x instanceof JSONArray) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < ((JSONArray)x).length(); ++i) {
                    if (i > 0) {
                        builder.append(" ");
                    }
                    builder.append(((JSONArray)x).getString(i));
                }
                description = builder.toString();
            } else {
                description = x.toString();
            }
            if (description.contains("@@@")) {
                description = StringUtils.replace((String)description, (String)"@@@", (String)FilenameUtils.removeExtension((String)jsonUrl.toString()));
            }
        }
        return description;
    }

    public static JSONObject getAction(JSONObject rule, String idAction) {
        if (!rule.has("actions")) {
            return null;
        }
        if (!rule.getJSONObject("actions").has(idAction)) {
            return null;
        }
        JSONObject action = rule.getJSONObject("actions").getJSONObject(idAction);
        return action;
    }
}

