/*
 * Decompiled with CFR 0.152.
 */
package es.idr.teledeteccion.connection.esri;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Set;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.wkt.Parser;
import org.gvsig.crs.CrsFactory;
import org.hsqldb.jdbc.jdbcDataSource;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

public class FactoryUsingHSQL
extends jdbcDataSource
implements CRSAuthorityFactory {
    protected Connection connection;
    protected CRSFactory crsFactory;
    private Hashtable cache = new Hashtable();
    public static final String DATABASE_NAME = "ESRI";

    public FactoryUsingHSQL() {
        try {
            this.loadDefault();
        }
        catch (IOException oops) {
            System.err.println("Could not load " + oops);
        }
    }

    protected FactoryUsingHSQL(CRSFactory factory) {
        this.crsFactory = factory;
        try {
            this.loadDefault();
        }
        catch (IOException oops) {
            System.err.println("Could not load " + oops);
        }
    }

    protected void loadDefault() throws IOException {
        String db = "jdbc:hsqldb:file:" + CrsFactory.getDataBaseFolder().getAbsolutePath() + "/esri";
        this.setDatabase(db);
        this.setUser("sa");
        try {
            this.connection = super.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        CoordinateReferenceSystem returnValue = null;
        String wkt = null;
        String ESRI_NUMBER = code.substring(code.indexOf(":") + 1, code.length());
        int cod = Integer.parseInt(ESRI_NUMBER);
        if (this.cache.contains(ESRI_NUMBER)) {
            Object value = this.cache.get(ESRI_NUMBER);
            if (value instanceof Throwable) {
                throw new FactoryException("WKT for " + code + " could not be parsed", (Throwable)value);
            }
            if (value instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)value;
            }
        }
        try {
            String sentence = "SELECT ESRI_WKT FROM ESRI WHERE ESRI_CODE = " + code.substring(code.indexOf(":") + 1, code.length());
            Statement st = null;
            ResultSet result = null;
            st = this.connection.createStatement();
            result = st.executeQuery(sentence);
            st.close();
            while (result.next()) {
                wkt = result.getString("esri_wkt");
            }
            result.close();
            if (wkt.indexOf(cod) == -1) {
                wkt = wkt.trim();
                wkt = wkt.substring(0, wkt.length() - 1);
                wkt = wkt + ",AUTHORITY[\"ESRI\",\"" + cod + "\"]]";
            }
        }
        catch (SQLException exception) {
            System.out.println(exception);
        }
        Parser parser = new Parser();
        try {
            returnValue = parser.parseCoordinateReferenceSystem(wkt);
        }
        catch (ParseException e) {
            System.out.println("Cadena WKT no ha podido ser parseada");
            e.printStackTrace();
        }
        return returnValue;
    }

    public CompoundCRS createCompoundCRS(String arg0) throws FactoryException {
        return null;
    }

    public DerivedCRS createDerivedCRS(String arg0) throws FactoryException {
        return null;
    }

    public EngineeringCRS createEngineeringCRS(String arg0) throws FactoryException {
        return null;
    }

    public GeographicCRS createGeographicCRS(String arg0) throws FactoryException {
        return null;
    }

    public GeocentricCRS createGeocentricCRS(String arg0) throws FactoryException {
        return null;
    }

    public ImageCRS createImageCRS(String arg0) throws FactoryException {
        return null;
    }

    public ProjectedCRS createProjectedCRS(String arg0) throws FactoryException {
        return null;
    }

    public TemporalCRS createTemporalCRS(String arg0) throws FactoryException {
        return null;
    }

    public VerticalCRS createVerticalCRS(String arg0) throws FactoryException {
        return null;
    }

    public Citation getAuthority() {
        Citation citation = CitationImpl.createCitation((String)"ESRI2");
        citation.getIdentifiers().add(DATABASE_NAME);
        return citation;
    }

    public Set getAuthorityCodes(Class arg0) throws FactoryException {
        return null;
    }

    public InternationalString getDescriptionText(String arg0) throws FactoryException {
        return null;
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public Citation getVendor() {
        return CitationImpl.ESRI;
    }
}

