/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrLambertConformalWestOrientated
extends MapProjection {
    private final double latitudeOfOrigin;

    protected IdrLambertConformalWestOrientated(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.LATITUDE_OF_ORIGIN)) {
            this.latitudeOfOrigin = Math.abs(IdrLambertConformalWestOrientated.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (ParameterValueGroup)parameters));
            IdrLambertConformalWestOrientated.ensureLatitudeInRange((ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (double)this.latitudeOfOrigin, (boolean)false);
        } else {
            this.latitudeOfOrigin = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.latitudeOfOrigin)) {
            List expected = this.getParameterDescriptors().descriptors();
            IdrLambertConformalWestOrientated.set((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (ParameterValueGroup)values, (double)this.latitudeOfOrigin);
        }
        return values;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_origin"), new NamedIdentifier(CitationImpl.EPSG, "CenterLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "NatOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "FalseOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of false origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "ProjCenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Lambert_Conic_Conformal_(West_Orientated)"), new NamedIdentifier(CitationImpl.EPSG, "Lambert_Conic_Conformal_(West_Orientated)"), new NamedIdentifier(CitationImpl.EPSG, "Lambert Conic Conformal (West Orientated)"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)34)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return ConicProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrLambertConformalWestOrientated(parameters);
        }
    }
}

