/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.measure.Latitude;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrMercator
extends MapProjection {
    protected final double standardParallel;

    protected IdrMercator(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, IdrMercator.getDescriptor(parameters).descriptors());
    }

    private static ParameterDescriptorGroup getDescriptor(ParameterValueGroup parameters) {
        try {
            parameters.parameter(Provider2SP.STANDARD_PARALLEL.getName().getCode());
            return Provider2SP.PARAMETERS;
        }
        catch (ParameterNotFoundException ignore) {
            return Provider1SP.PARAMETERS;
        }
    }

    IdrMercator(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
        if (expected.contains(Provider2SP.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(IdrMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider2SP.STANDARD_PARALLEL, (ParameterValueGroup)parameters));
            IdrMercator.ensureLatitudeInRange((ParameterDescriptor)Provider2SP.STANDARD_PARALLEL, (double)this.standardParallel, (boolean)false);
            this.scaleFactor = this.isSpherical ? (this.scaleFactor *= Math.cos(this.standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(this.standardParallel), Math.cos(this.standardParallel)));
            this.globalScale = this.scaleFactor * this.semiMajor;
        } else {
            this.standardParallel = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Double.isNaN(this.standardParallel) ? Provider1SP.PARAMETERS : Provider2SP.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            IdrMercator.set((Collection)expected, (ParameterDescriptor)Provider2SP.STANDARD_PARALLEL, (ParameterValueGroup)values, (double)this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y) > 1.5707953267948966) {
            throw new ProjectionException(Resources.format((int)119, (Object)new Latitude(Math.toDegrees(y))));
        }
        y = -Math.log(this.tsfn(y, Math.sin(y)));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        y = Math.exp(-y);
        y = this.cphi2(y);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdrMercator that = (IdrMercator)((Object)object);
            return IdrMercator.equals((double)this.standardParallel, (double)that.standardParallel);
        }
        return false;
    }

    private static final class Spherical
    extends IdrMercator {
        protected Spherical(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
            super(parameters, expected);
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (Math.abs(y) > 1.5707953267948966) {
                throw new ProjectionException(Resources.format((int)119, (Object)new Latitude(Math.toDegrees(y))));
            }
            y = Math.log(Math.tan(0.7853981633974483 + 0.5 * y));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }

    public static final class Provider2SP
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor STANDARD_PARALLEL = Provider2SP.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider2SP.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Mercator_2SP"), new NamedIdentifier(CitationImpl.EPSG, "Mercator (2SP)"), new NamedIdentifier(CitationImpl.EPSG, "9805"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_Mercator"), new NamedIdentifier(CitationImpl.ESRI, "Mercator"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)10)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider2SP() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider2SP.isSpherical((ParameterValueGroup)parameters)) {
                return new Spherical(parameters, descriptors);
            }
            return new IdrMercator(parameters, descriptors);
        }
    }

    public static final class Provider1SP
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = Provider1SP.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_origin"), new NamedIdentifier(CitationImpl.EPSG, "CenterLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "NatOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "FalseOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of false origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "ProjCenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider1SP.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Mercator_1SP"), new NamedIdentifier(CitationImpl.EPSG, "Mercator (1SP)"), new NamedIdentifier(CitationImpl.EPSG, "9804"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_Mercator"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)10)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, SCALE_FACTOR, LATITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING});

        public Provider1SP() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider1SP.isSpherical((ParameterValueGroup)parameters)) {
                return new Spherical(parameters, descriptors);
            }
            return new IdrMercator(parameters, descriptors);
        }
    }
}

