/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrSinusoidal
extends MapProjection {
    private final double longitudeOfCenter;

    protected IdrSinusoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.LONGITUDE_OF_CENTER)) {
            this.longitudeOfCenter = Math.abs(IdrSinusoidal.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)parameters));
            IdrSinusoidal.ensureLatitudeInRange((ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (double)this.longitudeOfCenter, (boolean)false);
        } else {
            this.longitudeOfCenter = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.longitudeOfCenter)) {
            List expected = this.getParameterDescriptors().descriptors();
            IdrSinusoidal.set((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.longitudeOfCenter);
        }
        return values;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptor LONGITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "longitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of origin"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of false origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "ProjCenterLong"), new NamedIdentifier(CitationImpl.EPSG, "NatOriginLong"), new NamedIdentifier(CitationImpl.EPSG, "central_meridian"), new NamedIdentifier(CitationImpl.EPSG, "CenterLong")}, (double)0.0, (double)-360.0, (double)360.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Sinusoidal"), new NamedIdentifier(CitationImpl.EPSG, "Sinusoidal"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONGITUDE_OF_CENTER, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrSinusoidal(parameters);
        }
    }
}

