/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.ogr;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsEPSG {
    private static final Logger logger = LoggerFactory.getLogger(CrsEPSG.class);
    int epsg_code;
    boolean crs_source;
    int source_code;
    int projection_code;
    int coord_op_code;
    int datum_code;
    int ellipsoid_code;
    int prime_meridian_code;
    String PROJCS = null;
    String GEOGCS = null;
    String DATUM = null;
    String[] SPHEROID = null;
    String[] PRIMEM = null;
    String UNIT_A = "degree";
    String UNIT_B = "Meter";
    double unit_BValue = 1.0;
    String PROJECTION = null;
    String[] param_name = null;
    String[] param_value = null;
    String[] AUTHORITY = null;
    EpsgConnection connect;
    private int coordSysCode;
    private static final double degree_factor_b = 3.14159265358979;
    private static final double degree_factor_c = 180.0;

    public CrsEPSG() {
    }

    public CrsEPSG(int code, boolean source_yn, int source_cod, int coord_op_cod, EpsgConnection conn) {
        this.epsg_code = code;
        this.crs_source = source_yn;
        this.source_code = source_cod;
        this.coord_op_code = coord_op_cod;
        this.connect = conn;
        this.SPHEROID = new String[3];
        this.PRIMEM = new String[2];
        this.AUTHORITY = new String[2];
        this.initialize();
    }

    public void initialize() {
        ResultSet result;
        String sentence;
        if (this.crs_source) {
            sentence = "SELECT coord_ref_sys_name, datum_code, coord_sys_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + this.epsg_code;
            result = Query.select(sentence, this.connect.getConnection());
            try {
                while (result.next()) {
                    this.GEOGCS = result.getString("coord_ref_sys_name");
                    this.datum_code = result.getInt("datum_code");
                    this.coordSysCode = result.getInt("coord_sys_code");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
            }
        } else {
            sentence = "SELECT coord_ref_sys_name, coord_sys_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + this.epsg_code;
            result = Query.select(sentence, this.connect.getConnection());
            String sentence2 = "SELECT coord_ref_sys_name, datum_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + this.source_code;
            ResultSet result2 = Query.select(sentence2, this.connect.getConnection());
            try {
                while (result.next()) {
                    this.PROJCS = result.getString("coord_ref_sys_name");
                    this.coordSysCode = result.getInt("coord_sys_code");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
            }
            try {
                while (result2.next()) {
                    this.datum_code = result2.getInt("datum_code");
                    this.GEOGCS = result2.getString("coord_ref_sys_name");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence2 + "'.", (Throwable)e);
            }
        }
        sentence = "SELECT datum_name, ellipsoid_code, prime_meridian_code FROM epsg_datum WHERE datum_code = " + this.datum_code;
        result = Query.select(sentence, this.connect.getConnection());
        try {
            while (result.next()) {
                this.DATUM = result.getString("datum_name");
                this.ellipsoid_code = result.getInt("ellipsoid_code");
                this.prime_meridian_code = result.getInt("prime_meridian_code");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
        }
        sentence = "SELECT ellipsoid_name, semi_major_axis, inv_flattening, uom_code, semi_minor_axis, ellipsoid_shape FROM epsg_ellipsoid WHERE ellipsoid_code = " + this.ellipsoid_code;
        result = Query.select(sentence, this.connect.getConnection());
        this.SPHEROID = this.getEllipsoid(result);
        sentence = "SELECT prime_meridian_name, greenwich_longitude, uom_code FROM epsg_primemeridian WHERE prime_meridian_code = " + this.prime_meridian_code;
        result = Query.select(sentence, this.connect.getConnection());
        this.PRIMEM = this.getPrimeMeridian(result);
        this.AUTHORITY = this.getAuthority(this.epsg_code);
        if (!this.crs_source) {
            sentence = "SELECT coord_op_method_code FROM epsg_coordoperation WHERE coord_op_code = " + this.coord_op_code;
            result = Query.select(sentence, this.connect.getConnection());
            try {
                while (result.next()) {
                    this.projection_code = result.getInt("coord_op_method_code");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
            }
            sentence = "SELECT coord_op_method_name FROM epsg_coordoperationmethod WHERE coord_op_method_code = " + this.projection_code;
            result = Query.select(sentence, this.connect.getConnection());
            try {
                while (result.next()) {
                    this.PROJECTION = result.getString("coord_op_method_name");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
            }
            this.parameters(this.projection_code);
            this.setUnit_B(this.coordSysCode);
        }
    }

    private String[] getEllipsoid(ResultSet result) {
        String[] spheroid = new String[3];
        double semi_major_axis = 0.0;
        double semi_minor_axis = 0.0;
        double inv_flattening = 0.0;
        int uom_code = 0;
        int ellipsoid_shape = 0;
        try {
            while (result.next()) {
                spheroid[0] = result.getString("ellipsoid_name");
                semi_major_axis = result.getDouble("semi_major_axis");
                semi_minor_axis = result.getDouble("semi_minor_axis");
                inv_flattening = result.getDouble("inv_flattening");
                uom_code = result.getInt("uom_code");
                ellipsoid_shape = result.getInt("ellipsoid_shape");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet.", (Throwable)e);
        }
        String sentence = "SELECT factor_b, factor_c FROM epsg_unitofmeasure WHERE uom_code = " + uom_code;
        ResultSet result2 = Query.select(sentence, this.connect.getConnection());
        double factor_b = 0.0;
        double factor_c = 0.0;
        try {
            while (result2.next()) {
                factor_b = result2.getDouble("factor_b");
                factor_c = result2.getDouble("factor_c");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
        }
        if (factor_b != 0.0 && factor_c != 0.0) {
            semi_major_axis = semi_major_axis * factor_b / factor_c;
            if (semi_minor_axis != 0.0) {
                semi_minor_axis = semi_minor_axis * factor_b / factor_c;
            }
        }
        if (inv_flattening == 0.0) {
            inv_flattening = ellipsoid_shape == 0 ? 0.0 : semi_major_axis / (semi_major_axis - semi_minor_axis);
        }
        spheroid[1] = "" + semi_major_axis;
        spheroid[2] = "" + inv_flattening;
        return spheroid;
    }

    /*
     * Unable to fully structure code
     */
    private String[] getPrimeMeridian(ResultSet result) {
        primem = new String[2];
        greenwich_longitude = 0.0;
lbl3:
        // 2 sources

        try {
            while (result.next()) {
                block4: {
                    primem[0] = result.getString("prime_meridian_name");
                    greenwich_longitude = result.getDouble("greenwich_longitude");
                    co = result.getInt("uom_code");
                    result2 = null;
                    if (co == 9110) break block4;
                    sentence = "SELECT factor_b, factor_c FROM epsg_unitofmeasure WHERE uom_code = " + co;
                    result2 = Query.select(sentence, this.connect.getConnection());
                    while (result.next()) {
                        factor_b = result2.getDouble("factor_b");
                        factor_c = result2.getDouble("factor_c");
                        greenwich_longitude *= factor_b / factor_c * 57.29577951308238;
                    }
                    ** GOTO lbl3
                }
                greenwich_longitude = this.Dms2Deg(greenwich_longitude);
            }
        }
        catch (SQLException e) {
            CrsEPSG.logger.error("Can't get values from ResulSet.", (Throwable)e);
        }
        primem[1] = "" + greenwich_longitude;
        return primem;
    }

    private void parameters(int proj) {
        String sentence = "SELECT COUNT(*) FROM epsg_coordoperationparamusage WHERE coord_op_method_code = " + proj;
        ResultSet result = Query.select(sentence, this.connect.getConnection());
        int count = 0;
        try {
            result.next();
            count = result.getInt(1);
        }
        catch (SQLException e1) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e1);
        }
        this.param_name = new String[count];
        this.param_value = new String[count];
        sentence = "SELECT parameter_code FROM epsg_coordoperationparamusage WHERE coord_op_method_code = " + proj + " " + "ORDER BY sort_order ASC";
        result = Query.select(sentence, this.connect.getConnection());
        int i = 0;
        try {
            while (result.next()) {
                int cod = result.getInt("parameter_code");
                sentence = "SELECT parameter_name FROM epsg_coordoperationparam WHERE parameter_code = " + cod;
                ResultSet result2 = Query.select(sentence, this.connect.getConnection());
                result2.next();
                this.param_name[i] = result2.getString("parameter_name");
                sentence = "SELECT parameter_value, uom_code FROM epsg_coordoperationparamvalue WHERE parameter_code = " + cod + " AND coord_op_code = " + this.coord_op_code;
                ResultSet result3 = Query.select(sentence, this.connect.getConnection());
                result3.next();
                double param_val = result3.getDouble("parameter_value");
                int uom_code = result3.getInt("uom_code");
                sentence = "SELECT factor_b, factor_c, unit_of_meas_type FROM epsg_unitofmeasure WHERE uom_code = " + uom_code;
                ResultSet result4 = Query.select(sentence, this.connect.getConnection());
                double factor_b = 0.0;
                double factor_c = 0.0;
                result4.next();
                String type = result4.getString("unit_of_meas_type");
                factor_b = result4.getDouble("factor_b");
                factor_c = result4.getDouble("factor_c");
                if (factor_b != 0.0 && factor_c != 0.0 && !type.equals("angle")) {
                    param_val *= factor_b / factor_c;
                } else if (factor_b != 0.0 && factor_c != 0.0 && type.equals("angle")) {
                    param_val *= factor_b / factor_c * 57.29577951308238;
                } else if (uom_code == 9110) {
                    param_val = this.especialDegree(param_val);
                } else {
                    logger.info("C\u00f3digo de medida (uom) '" + uom_code + "' no v\u00e1lido (factor_b=" + factor_b + ",factor_c=" + factor_c + ",type=" + type + ").");
                }
                if (Math.abs(param_val - (double)Math.round(param_val)) < 1.0E-13) {
                    param_val = Math.round(param_val);
                }
                this.param_value[i] = "" + param_val;
                ++i;
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
        }
    }

    private double especialDegree(double val) {
        if (val == 0.0) {
            return val;
        }
        int signo = 1;
        if (val < 0.0) {
            signo = -1;
            val = Math.abs(val);
        }
        String strValue = String.valueOf(val);
        int posPto = strValue.indexOf(46);
        double grad = Double.parseDouble(strValue.substring(0, posPto));
        String strFraction = strValue.substring(posPto + 1);
        double min = 0.0;
        double sec = 0.0;
        if (strFraction.length() == 1) {
            min = Double.parseDouble(strFraction);
            min *= 10.0;
        }
        if (strFraction.length() == 2) {
            min = Double.parseDouble(strFraction);
        }
        if (strFraction.length() > 2) {
            min = Double.parseDouble(strFraction.substring(0, 2));
            sec = Double.parseDouble(strFraction.substring(2));
            if (strFraction.length() == 3) {
                sec *= 10.0;
            }
            if (strFraction.length() > 4) {
                for (int i = 0; i < strFraction.length() - 4; ++i) {
                    sec /= 10.0;
                }
            }
        }
        val = (grad + min / 60.0 + sec / 3600.0) * (double)signo;
        return val;
    }

    private double Dms2Deg(double val) {
        if (val == 0.0) {
            return val;
        }
        int signo = 1;
        if (val < 0.0) {
            signo = -1;
            val = Math.abs(val);
        }
        String strValue = String.valueOf(val);
        int posPto = strValue.indexOf(46);
        double grad = Double.parseDouble(strValue.substring(0, posPto));
        String strFraction = strValue.substring(posPto + 1);
        double min = 0.0;
        double sec = 0.0;
        if (strFraction.length() == 1) {
            min = Double.parseDouble(strFraction);
            min *= 10.0;
        }
        if (strFraction.length() == 2) {
            min = Double.parseDouble(strFraction);
        }
        if (strFraction.length() > 2) {
            min = Double.parseDouble(strFraction.substring(0, 2));
            sec = Double.parseDouble(strFraction.substring(2));
            if (strFraction.length() == 3) {
                sec *= 10.0;
            }
            if (strFraction.length() > 4) {
                for (int i = 0; i < strFraction.length() - 4; ++i) {
                    sec /= 10.0;
                }
            }
        }
        val = (grad + min / 60.0 + sec / 3600.0) * (double)signo;
        return val;
    }

    private String[] getAuthority(int epsg_cod) {
        String[] aut = new String[]{"EPSG", "" + epsg_cod};
        return aut;
    }

    public String getPROJCS() {
        return this.PROJCS;
    }

    public String getGEOGCS() {
        return this.GEOGCS;
    }

    public String getDATUM() {
        return this.DATUM;
    }

    public String[] getSPHEROID() {
        return this.SPHEROID;
    }

    public String[] getPRIMEM() {
        return this.PRIMEM;
    }

    public void setUnit_B(int code) {
        int uom = 0;
        String sentence = "SELECT uom_code FROM epsg_coordinateaxis WHERE coord_sys_code = " + code;
        ResultSet result = Query.select(sentence, this.connect.getConnection());
        try {
            if (result.next()) {
                uom = result.getInt("uom_code");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
        }
        sentence = "SELECT unit_of_meas_name FROM epsg_unitofmeasure WHERE uom_code = " + uom;
        result = Query.select(sentence, this.connect.getConnection());
        try {
            if (result.next()) {
                this.UNIT_B = result.getString("unit_of_meas_name");
            }
        }
        catch (SQLException e) {
            logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
        }
        this.setUnit_BValue(uom);
    }

    private void setUnit_BValue(int uom) {
        if (uom != 9001) {
            double factor_b = 0.0;
            double factor_c = 0.0;
            String sentence = "SELECT factor_b, factor_c FROM epsg_unitofmeasure WHERE uom_code = " + uom;
            ResultSet result = Query.select(sentence, this.connect.getConnection());
            try {
                if (result.next()) {
                    factor_b = result.getDouble("factor_b");
                    factor_c = result.getDouble("factor_c");
                }
            }
            catch (SQLException e) {
                logger.error("Can't get values from ResulSet '" + sentence + "'.", (Throwable)e);
            }
            this.unit_BValue = this.unit_BValue * factor_b / factor_c;
            this.UNIT_B = uom != 9002 ? "[m*" + this.unit_BValue + "]" : "ft";
        }
    }

    public String getUNIT_A() {
        return this.UNIT_A;
    }

    public String getPROJECTION() {
        return this.PROJECTION;
    }

    public String[] getParam_name() {
        return this.param_name;
    }

    public String[] getParam_value() {
        return this.param_value;
    }

    public String getUNIT_B() {
        return this.UNIT_B;
    }

    public String getUnit_BValue() {
        return "" + this.unit_BValue;
    }

    public String[] getAUTHORITY() {
        return this.AUTHORITY;
    }
}

