/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.repository.ICrsRepository;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsrRepository
implements ICrsRepository,
Disposable {
    private static final Logger LOG = LoggerFactory.getLogger(UsrRepository.class);
    EpsgConnection connection = new EpsgConnection();

    public ICrs getCrs(String code) {
        String cadWKT = "";
        Crs crs = null;
        String sentence = "SELECT usr_code, usr_wkt, usr_proj, usr_geog, usr_datum FROM USR WHERE usr_code = " + code;
        this.connection.setConnectionUsr();
        ResultSet result = Query.select(sentence, this.connection.getConnection());
        try {
            this.connection.shutdown();
        }
        catch (SQLException e) {
            LOG.info("Error executing the SQL", (Throwable)e);
            return null;
        }
        try {
            if (!result.next()) {
                return null;
            }
            cadWKT = result.getString("usr_wkt");
        }
        catch (SQLException e1) {
            LOG.info("Impossible to execute the SQL", (Throwable)e1);
            return null;
        }
        cadWKT = cadWKT.substring(0, cadWKT.length() - 1) + ", AUTHORITY[\"USR\"," + Integer.parseInt(code) + "]]";
        try {
            crs = new Crs(Integer.parseInt(code), cadWKT);
        }
        catch (CrsException e) {
            LOG.info("Impossible to parse the CRS", (Throwable)e);
        }
        return crs;
    }

    public void dispose() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            LOG.warn("Con't shutdown the connection.", (Throwable)ex);
        }
    }
}

