/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.AbstractIdentifyStrategy;

public class IdentifyEPSGNormalizing
extends AbstractIdentifyStrategy {
    private int accuracy;
    private int best_dist = 1000;
    private int best_code = 0;

    public IdentifyEPSGNormalizing() {
        this(5);
    }

    public IdentifyEPSGNormalizing(int accuracy) {
        this.accuracy = accuracy;
    }

    public IdentifyEPSGNormalizing setAccuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public int getBestAccuracy() {
        return this.best_dist;
    }

    public SpatialReference getBest() {
        SpatialReference sr = this.createSpatialReferenceFromEPSGCode(this.best_code);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpatialReference identify(SpatialReference sr) {
        String source_sr_name;
        String attr;
        String kind;
        if (this.autoIdentifyEPSG(sr)) {
            return sr;
        }
        this.best_code = 0;
        this.best_dist = 1000;
        if (sr.IsGeographic() == 1) {
            kind = "geographic 2D";
            attr = "GEOGCS";
            source_sr_name = sr.GetAttrValue(attr);
            if (source_sr_name == null) {
                return null;
            }
            StringUtils.replace((String)source_sr_name.toLowerCase(), (String)"_", (String)" ");
            if (StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 1989")) {
                source_sr_name = "etrs89";
            }
        } else {
            if (sr.IsProjected() != 1) return null;
            kind = "projected";
            attr = "PROJCS";
            source_sr_name = sr.GetAttrValue(attr);
        }
        logger.debug("Source SR name: {}", (Object)source_sr_name);
        sr.StripCTParms();
        String sql = "SELECT coord_ref_sys_code FROM EPSG_COORDINATEREFERENCESYSTEM WHERE coord_ref_sys_kind = '" + kind + "' AND REPLACE(REPLACE(LOWER(coord_ref_sys_name),' / ',' '),'-',' ') LIKE '%" + this.normalizeEPSGSrName(source_sr_name) + "%' AND deprecated = 0";
        logger.debug(sql);
        EpsgConnection conn = null;
        try {
            conn = new EpsgConnection();
            conn.setConnectionEPSG();
            ResultSet result = Query.select(sql, conn.getConnection());
            while (result.next()) {
                int dist;
                int code = result.getInt("coord_ref_sys_code");
                try {
                    logger.debug("Trying to match EPSG:{}...", (Object)code);
                    SpatialReference target_sr = this.createSpatialReferenceFromEPSGCode(code);
                    String target_sr_name = target_sr.GetAttrValue(attr);
                    target_sr.StripCTParms();
                    logger.debug("Target SR name: {}", (Object)target_sr_name);
                    dist = StringUtils.getLevenshteinDistance((CharSequence)this.normalizeEPSGSrName(source_sr_name), (CharSequence)this.normalizeEPSGSrName(target_sr_name));
                    if (dist == 0) {
                        logger.debug("EPSG:{} matches!", (Object)code);
                        SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(code);
                        if (sr2 != null) {
                            SpatialReference spatialReference = sr2;
                            return spatialReference;
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Can't identify wkt.", (Throwable)e);
                }
                {
                    if (dist >= this.best_dist) continue;
                    this.best_dist = dist;
                    this.best_code = code;
                }
            }
        }
        catch (Exception e2) {
            logger.debug("Can't identify wkt.", (Throwable)e2);
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        if (this.best_code <= 0) return null;
        if (this.best_dist > this.accuracy) return null;
        logger.debug("EPSG:{} is the best match (Levenshtein Distance = {}).", (Object)this.best_code, (Object)this.best_dist);
        SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(this.best_code);
        if (sr2 == null) return null;
        return sr2;
    }
}

