/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.AbstractIdentifyStrategy;

public class IdentifyEsri
extends AbstractIdentifyStrategy {
    private int best_code;

    public int getBestAccuracy() {
        if (this.best_code == 0) {
            return 1000;
        }
        return 0;
    }

    public SpatialReference getBest() {
        SpatialReference sr = this.createSpatialReferenceFromEPSGCode(this.best_code);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpatialReference identify(SpatialReference sr) {
        if (this.autoIdentifyEPSG(sr)) {
            return sr;
        }
        String source_proj4 = this.getProj4String(sr);
        String sql = "";
        if (sr.IsGeographic() == 1) {
            sql = "SELECT ESRI_CODE, ESRI_WKT FROM ESRI WHERE ESRI_WKT LIKE 'GEOGCS%' AND ESRI_GEOG LIKE '" + StringUtils.replace((String)sr.GetAttrValue("GEOGCS"), (String)"'", (String)"''") + "'";
        } else if (sr.IsProjected() == 1) {
            sql = "SELECT ESRI_CODE, ESRI_WKT FROM ESRI WHERE ESRI_WKT LIKE 'PROJCS%' AND ESRI_PROJ LIKE '" + StringUtils.replace((String)sr.GetAttrValue("PROJCS"), (String)"'", (String)"''") + "'";
        }
        logger.debug(sql);
        int code = 0;
        this.best_code = 0;
        EpsgConnection conn = null;
        try {
            conn = new EpsgConnection();
            conn.setConnectionEsri();
            ResultSet result = Query.select(sql, conn.getConnection());
            while (result.next()) {
                code = result.getInt("ESRI_CODE");
                String wkt = result.getString("ESRI_WKT");
                logger.debug("Trying to match ESRI:{}...", (Object)code);
                try {
                    SpatialReference target_sr = new SpatialReference();
                    target_sr.ImportFromWkt(wkt);
                    target_sr.MorphFromESRI();
                    String target_proj4 = target_sr.ExportToProj4();
                    if (!StringUtils.equals((CharSequence)source_proj4, (CharSequence)target_proj4)) continue;
                    logger.debug("ESRI:{} matches!", (Object)code);
                    this.best_code = code;
                    SpatialReference spatialReference = this.createSpatialReferenceFromESRICode(code);
                    return spatialReference;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        logger.debug("Can't identify the ESRI code...");
        this.best_code = 0;
        return null;
    }
}

