/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.components;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInstantTypeNotRegisteredException;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.swing.impl.components.DateTextListener;
import org.gvsig.timesupport.swing.impl.components.JTemporalDateText;
import org.gvsig.timesupport.swing.impl.components.TemporalComponent;
import org.gvsig.timesupport.swing.impl.rdv.TimeAdjustmentListener;
import org.gvsig.timesupport.swing.impl.rdv.TimeEvent;

public class AbsoluteTemporalComponent
extends JPanel
implements TemporalComponent,
DateTextListener {
    private static final long serialVersionUID = 4486793564004694709L;
    private TimeAdjustmentListener listener;
    private AbsoluteInstant initTime;
    private JTemporalDateText jDateText;
    private JLabel lblLabel = null;

    public AbsoluteTemporalComponent() {
        this.initComponents();
    }

    @Override
    public TimeAdjustmentListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(TimeAdjustmentListener listener) {
        this.listener = listener;
    }

    @Override
    public void setTimes(String label, Time init, Time lower, Time upper) {
        this.initTime = (AbsoluteInstant)init;
        this.getTemporalDateText().setInstant(this.initTime);
        this.getLabel().setText(label + " " + this.initTime.toString());
    }

    @Override
    public void setCurrentInstant(Time date) {
        this.getTemporalDateText().setInstant((AbsoluteInstant)date);
    }

    @Override
    public void setStartTime(Time date) {
    }

    @Override
    public void setEndTime(Time date) {
    }

    @Override
    public Time getTime() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        try {
            values.add(this.getTemporalDateText().getYears());
            types.add(5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getWeekOfWeekYear());
            types.add(7);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getMonthOfYear());
            types.add(11);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getDayOfMonth());
            types.add(8);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getHourOfDay());
            types.add(17);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getMinuteOfHour());
            types.add(19);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getSecondOfMinute());
            types.add(21);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            values.add(this.getTemporalDateText().getMillisOfSecond());
            types.add(23);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int[] vTypes = new int[types.size()];
        int[] vValues = new int[types.size()];
        for (int i = 0; i < vTypes.length; ++i) {
            vTypes[i] = (Integer)types.get(i);
            vValues[i] = (Integer)values.get(i);
        }
        try {
            TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();
            return timeSupportManager.createAbsoluteInstant(vTypes, vValues);
        }
        catch (AbsoluteInstantTypeNotRegisteredException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void resetLowertTime() {
    }

    @Override
    public void resetUpperTime() {
    }

    @Override
    public void resetValues() {
        this.getTemporalDateText().setInstant(this.initTime);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.listener != null) {
            this.listener.timeChanged(new TimeEvent(this));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.timeChanged(new TimeEvent(this));
        }
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getLabel());
        this.getTemporalDateText().setListener(this);
        this.add(this.getTemporalDateText());
    }

    private JTemporalDateText getTemporalDateText() {
        if (this.jDateText == null) {
            this.jDateText = new JTemporalDateText();
        }
        return this.jDateText;
    }

    private JLabel getLabel() {
        if (this.lblLabel == null) {
            this.lblLabel = new JLabel();
        }
        return this.lblLabel;
    }
}

