/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.i18n.Messages;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.swing.api.panel.TimeSelectorPanel;
import org.gvsig.timesupport.swing.impl.components.InstantComparator;
import org.gvsig.timesupport.swing.impl.panel.TimePanel;
import org.gvsig.timesupport.swing.impl.panel.UpdateTimeNotification;
import org.gvsig.timesupport.swing.impl.rdv.TimeAdjustmentListener;
import org.gvsig.timesupport.swing.impl.rdv.TimeEvent;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class DefaultTimeSliderPanel
extends JPanel
implements TimeSelectorPanel,
TimeAdjustmentListener {
    private static final long serialVersionUID = 213502960867760481L;
    private JRadioButton rdbNone = null;
    private JRadioButton rdbInterval = null;
    private JRadioButton rdbInstant = null;
    private TimePanel timePanel = null;
    private List<Observer> observers = new ArrayList<Observer>();
    private Interval interval;

    public void setIntervals(Interval interval) {
        this.interval = interval;
        this.initialize(this.interval.getStart(), this.interval.getEnd());
    }

    public void initialize(Instant start, Instant end) {
        this.removeAll();
        this.revalidate();
        this.repaint();
        this.createUI();
        if (start.isAbsolute()) {
            this.timePanel.setTimeMode(TimePanel.TIME_MODE.ABSOLUTE, start, end);
        } else {
            this.timePanel.setTimeMode(TimePanel.TIME_MODE.RELATIVE, start, end);
        }
    }

    @Override
    public void timeChanged(TimeEvent event) {
        if (this.getInstantRadioButton().isSelected()) {
            Instant instante = this.timePanel.getInstant();
            if (!this.observers.isEmpty()) {
                for (Observer o : this.observers) {
                    o.update((Observable)this, (Object)new UpdateTimeNotification((Time)instante));
                }
            }
        }
    }

    @Override
    public void rangeChanged(TimeEvent event) {
        if (this.getIntervalRadioButton().isSelected() && !this.observers.isEmpty()) {
            for (Observer o : this.observers) {
                o.update((Observable)this, (Object)new UpdateTimeNotification((Time)this.timePanel.getInterval()));
            }
        }
    }

    @Override
    public void boundsChanged(TimeEvent event) {
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(new Rectangle(r.x, r.y, 1, 2));
    }

    public boolean isInterval() {
        return this.getIntervalRadioButton().isSelected();
    }

    public boolean isInstant() {
        return this.getInstantRadioButton().isSelected();
    }

    public boolean isNone() {
        return this.getNoneRadioButton().isSelected();
    }

    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    public void deleteObservers() {
        this.observers.clear();
    }

    public void setInstants(Instant start, Instant end) {
        this.timePanel.setInstants(start, end);
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createRadioButtons(), "North");
        this.timePanel = new TimePanel();
        this.timePanel.setListener(this);
        this.add((Component)this.timePanel, "Center");
        Dimension size = this.getPreferredSize();
        if (size.width < 400) {
            size.width = 400;
        }
        if (size.height < 140) {
            size.height = 140;
        }
        this.setPreferredSize(size);
        this.timePanel.fireRangeInterval();
    }

    private JPanel createRadioButtons() {
        ButtonGroup group = new ButtonGroup();
        this.getNoneRadioButton().addActionListener(new ActionNoneButton(this));
        group.add(this.getNoneRadioButton());
        this.getIntervalRadioButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTimeSliderPanel.this.timePanel.setEnabled(true);
                DefaultTimeSliderPanel.this.timePanel.resetValues();
                DefaultTimeSliderPanel.this.timePanel.setValueChangeableSlider(false);
                DefaultTimeSliderPanel.this.timePanel.fireRangeInterval();
            }
        });
        this.getIntervalRadioButton().setSelected(true);
        group.add(this.getIntervalRadioButton());
        this.getInstantRadioButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTimeSliderPanel.this.timePanel.setEnabled(true);
                DefaultTimeSliderPanel.this.timePanel.setEnabledEndCalendar(false);
                DefaultTimeSliderPanel.this.timePanel.setValueChangeableSlider(true);
                DefaultTimeSliderPanel.this.timePanel.resetValues();
                DefaultTimeSliderPanel.this.timePanel.fireValueInstant();
            }
        });
        group.add(this.getInstantRadioButton());
        JPanel radio = new JPanel();
        radio.setLayout(new FlowLayout());
        radio.add(this.getNoneRadioButton());
        radio.add(this.getIntervalRadioButton());
        radio.add(this.getInstantRadioButton());
        return radio;
    }

    private JRadioButton getNoneRadioButton() {
        if (this.rdbNone == null) {
            this.rdbNone = new JRadioButton(Messages.getText((String)"rdButton_none"));
        }
        return this.rdbNone;
    }

    private JRadioButton getIntervalRadioButton() {
        if (this.rdbInterval == null) {
            this.rdbInterval = new JRadioButton(Messages.getText((String)"rdButton_interval"));
        }
        return this.rdbInterval;
    }

    private JRadioButton getInstantRadioButton() {
        if (this.rdbInstant == null) {
            this.rdbInstant = new JRadioButton(Messages.getText((String)"rdButton_instant"));
        }
        return this.rdbInstant;
    }

    void noneButtonAction() {
        if (!this.observers.isEmpty()) {
            for (Observer o : this.observers) {
                o.update((Observable)this, (Object)new UpdateTimeNotification(null));
            }
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setInstants(List<Instant> instants) {
        Collections.sort(instants, new InstantComparator());
        Iterator<Instant> iterador = instants.iterator();
        ArrayList<Instant> sortedList = new ArrayList<Instant>();
        while (iterador.hasNext()) {
            Instant obj = iterador.next();
            if (sortedList.contains(obj)) continue;
            sortedList.add(obj);
        }
        this.timePanel.setInstants(sortedList);
    }

    private class ActionNoneButton
    implements ActionListener {
        private final DefaultTimeSliderPanel panel;

        public ActionNoneButton(DefaultTimeSliderPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTimeSliderPanel.this.timePanel.setEnabled(false);
            this.panel.noneButtonAction();
        }
    }
}

