/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.panel;

import java.awt.Component;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.i18n.Messages;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.AbsoluteIntervalTypeNotRegisteredException;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.swing.impl.components.AbsoluteTemporalComponent;
import org.gvsig.timesupport.swing.impl.components.RelativeTemporalComponent;
import org.gvsig.timesupport.swing.impl.components.TemporalComponent;
import org.gvsig.timesupport.swing.impl.rdv.TimeAdjustmentListener;
import org.gvsig.timesupport.swing.impl.rdv.TimeEvent;
import org.gvsig.timesupport.swing.impl.rdv.TimeSlider;

public class TimePanel
extends JPanel
implements TimeAdjustmentListener {
    private static final long serialVersionUID = -1711925095164453822L;
    private TIME_MODE _mode = TIME_MODE.RELATIVE;
    private TimeSlider slider = null;
    private TemporalComponent jComponentStart = null;
    private TemporalComponent jComponentEnd = null;
    private Instant startDate = null;
    private Instant endDate = null;
    private Instant startBackupForInterval = null;
    private Instant endBackupForInterval = null;
    private Interval interval = null;
    private boolean eventSynchronized = false;
    private List<Instant> instants = null;
    private int instantsPosition;
    private Instant actual = null;
    private Instant instAux = null;
    private boolean updateSlider = false;
    private static TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();
    private TimeAdjustmentListener listener = null;

    public void initialize(Instant start, Instant end) {
        this.createComponents(start, end);
        this.startBackupForInterval = start;
        this.endBackupForInterval = end;
    }

    public void setInstants(Instant start, Instant end) {
        this.startDate = start;
        this.endDate = end;
        this.getJComponentStart().setTimes(Messages.getText((String)"lbl_begin_position"), (Time)this.startDate, (Time)this.startDate, (Time)this.endDate);
        this.getJComponentEnd().setTimes(Messages.getText((String)"lbl_end_position"), (Time)this.endDate, (Time)this.startDate, (Time)this.endDate);
        this.getTimeSlider().setValues(this.startDate, this.endDate);
    }

    public void setTimeMode(TIME_MODE mode, Instant start, Instant end) {
        this._mode = mode;
        this.initialize(start, end);
    }

    public TIME_MODE getTimeMode() {
        return this._mode;
    }

    public void setListener(TimeAdjustmentListener listener) {
        this.listener = listener;
    }

    public TimeAdjustmentListener getListener() {
        return this.listener;
    }

    public void setValueChangeableSlider(boolean changeable) {
        if (changeable) {
            if (this.interval != null) {
                this.startBackupForInterval = this.startDate;
                this.startBackupForInterval = this.endDate;
                this.setInstants(this.interval.getStart(), this.interval.getEnd());
            }
        } else if (this.interval != null) {
            this.setInstants(this.startBackupForInterval, this.endBackupForInterval);
        }
        this.getTimeSlider().setValueChangeable(changeable);
    }

    public void setInstants(List<Instant> instants) {
        this.instants = instants;
        this.instantsPosition = 0;
        this.actual = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeChanged(TimeEvent event) {
        if (!this.isUpdating()) {
            this.setUpdating(true);
            if (event.getSource() instanceof TimeSlider) {
                if (this.getTimeSlider().getValueChangeable()) {
                    if (CollectionUtils.isNotEmpty(this.instants) && !this.updateSlider) {
                        this.updateSlider = true;
                        if (!this.getTimeSlider().isValueAdjusting()) {
                            this.getTimeSlider().setCurrentInstant(this.getApproximateInstant(this.getTimeSlider().getCurrentInstant()));
                            this.getJComponentStart().setCurrentInstant((Time)this.getTimeSlider().getCurrentInstant());
                        }
                        this.updateSlider = false;
                    } else {
                        this.getJComponentStart().setCurrentInstant((Time)this.getTimeSlider().getCurrentInstant());
                    }
                }
            } else if (event.getSource() instanceof TemporalComponent) {
                TemporalComponent calendar = (TemporalComponent)event.getSource();
                if (calendar == this.getJComponentStart()) {
                    if (!this.getTimeSlider().getValueChangeable()) {
                        try {
                            if (!this.updateSlider) {
                                this.getTimeSlider().setStartInstant((Instant)this.getJComponentStart().getTime());
                            }
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (!this.getTimeSlider().getValueChangeable()) {
                    try {
                        if (!this.updateSlider) {
                            this.getTimeSlider().setEndInstant((Instant)this.getJComponentEnd().getTime());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
                this.updateCalendars();
            } else {
                try {
                    if (CollectionUtils.isEmpty(this.instants)) {
                        this.getTimeSlider().setCurrentInstant((Instant)this.getJComponentStart().getTime());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            if (this.getTimeSlider().getValueChangeable() && this.listener != null) {
                this.listener.timeChanged(new TimeEvent(this));
            }
            this.setUpdating(false);
        }
    }

    @Override
    public void rangeChanged(TimeEvent event) {
        if (event.getSource() instanceof TimeSlider) {
            this.getJComponentStart().setCurrentInstant((Time)this.getTimeSlider().getStartInstant());
            this.getJComponentEnd().setCurrentInstant((Time)this.getTimeSlider().getEndInstant());
        }
        if (!this.getTimeSlider().getValueChangeable() && this.listener != null) {
            this.listener.rangeChanged(new TimeEvent(this));
        }
    }

    public void fireRangeInterval() {
        this.getTimeSlider().fireRangeChanged();
    }

    public void fireValueInstant() {
        this.getTimeSlider().fireValueChanged();
    }

    @Override
    public void boundsChanged(TimeEvent event) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJComponentStart().setEnabled(enabled);
        this.getJComponentEnd().setEnabled(enabled);
        this.getTimeSlider().setEnabled(enabled);
    }

    public void resetValues() {
        this.getTimeSlider().resetAllDates();
        this.getJComponentStart().resetValues();
        this.getJComponentEnd().resetValues();
    }

    public void setEnabledEndCalendar(boolean enabled) {
        this.getJComponentEnd().setEnabled(enabled);
    }

    public Interval getInterval() {
        if (this.datesCorrect()) {
            if (this._mode == TIME_MODE.RELATIVE) {
                return timeSupportManager.createRelativeInterval((RelativeInstant)this.getJComponentStart().getTime(), (RelativeInstant)this.getJComponentEnd().getTime());
            }
            try {
                AbsoluteInstant start = (AbsoluteInstant)this.getJComponentStart().getTime();
                AbsoluteInstant end = (AbsoluteInstant)this.getJComponentEnd().getTime();
                return this.createAbsoluteInterval(start, end);
            }
            catch (AbsoluteIntervalTypeNotRegisteredException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public Instant getInstant() {
        if (this.datesCorrect()) {
            try {
                return (Instant)this.getJComponentStart().getTime();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    private void createUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)((Object)this.getJComponentStart()));
        this.add(this.getTimeSlider());
        this.add((Component)((Object)this.getJComponentEnd()));
        this.getTimeSlider().setValueChangeable(false);
        this.getJComponentStart().setListener(this);
        this.getJComponentEnd().setListener(this);
        this.getTimeSlider().addTimeAdjustmentListener(this);
    }

    private void createComponents(Instant start, Instant end) {
        this.removeAll();
        this.revalidate();
        this.repaint();
        this.jComponentStart = null;
        this.jComponentEnd = null;
        this.slider = null;
        this.setInstants(start, end);
        this.createUI();
    }

    private boolean datesCorrect() {
        if (this.getJComponentStart().isEnabled() && this.getJComponentEnd().isEnabled()) {
            try {
                Instant init = (Instant)this.getJComponentStart().getTime();
                Instant end = (Instant)this.getJComponentEnd().getTime();
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    private TimeSlider getTimeSlider() {
        if (this.slider == null) {
            this.slider = this._mode == TIME_MODE.RELATIVE ? new TimeSlider(false) : new TimeSlider(true);
        }
        return this.slider;
    }

    private TemporalComponent getJComponentStart() {
        if (this.jComponentStart == null) {
            this.jComponentStart = this._mode == TIME_MODE.RELATIVE ? new RelativeTemporalComponent() : new AbsoluteTemporalComponent();
        }
        return this.jComponentStart;
    }

    private TemporalComponent getJComponentEnd() {
        if (this.jComponentEnd == null) {
            this.jComponentEnd = this._mode == TIME_MODE.RELATIVE ? new RelativeTemporalComponent() : new AbsoluteTemporalComponent();
        }
        return this.jComponentEnd;
    }

    private void updateCalendars() {
        try {
            Instant start = (Instant)this.getJComponentStart().getTime();
            Instant end = (Instant)this.getJComponentEnd().getTime();
            this.getJComponentStart().setEndTime((Time)end);
            this.getJComponentEnd().setStartTime((Time)start);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean isUpdating() {
        return this.eventSynchronized;
    }

    private void setUpdating(boolean value) {
        this.eventSynchronized = value;
    }

    private AbsoluteInterval createAbsoluteInterval(AbsoluteInstant start, AbsoluteInstant end) throws AbsoluteIntervalTypeNotRegisteredException {
        long millisStart = start.toStandardDuration().getMillis();
        long millisEnd = end.toStandardDuration().getMillis();
        long millisInterval = millisEnd - millisStart;
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int millis = 0;
        long mod = millisInterval % 31536000000L;
        if (millisInterval / 31536000000L > 0L) {
            years = (int)(millisInterval / 31536000000L);
            millisInterval = mod;
        }
        mod = millisInterval % 2592000000L;
        if (millisInterval / 2592000000L > 0L) {
            months = (int)(millisInterval / 2592000000L);
            millisInterval = mod;
        }
        mod = millisInterval % 604800000L;
        if (millisInterval / 604800000L > 0L) {
            weeks = (int)(millisInterval / 604800000L);
            millisInterval = mod;
        }
        mod = millisInterval % 86400000L;
        if (millisInterval / 86400000L > 0L) {
            if ((int)(millisInterval / 86400000L) > 0) {
                days = (int)(millisInterval / 86400000L);
            }
            millisInterval = mod;
        }
        mod = millisInterval % 3600000L;
        if (millisInterval / 3600000L > 0L) {
            hours = (int)(millisInterval / 3600000L);
            millisInterval = mod;
        }
        mod = millisInterval % 60000L;
        if (millisInterval / 60000L > 0L) {
            seconds = (int)(millisInterval / 60000L);
            millisInterval = mod;
        }
        mod = millisInterval % 1000L;
        if (millisInterval / 1000L > 0L) {
            seconds = (int)(millisInterval / 1000L);
            millisInterval = mod;
        }
        if ((mod = millisInterval) > 0L) {
            millis = (int)mod;
        }
        return timeSupportManager.createAbsoluteInterval(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    private Instant getApproximateInstant(Instant instant) {
        int index = 0;
        if (instant.isBefore(this.instants.get(0))) {
            return this.instants.get(0);
        }
        for (Instant ins : this.instants) {
            if (ins.isEqual(instant)) {
                return ins;
            }
            if (ins.isAfter(instant)) break;
            ++index;
        }
        if (index == this.instants.size()) {
            return this.instants.get(this.instants.size() - 1);
        }
        return this.instants.get(index);
    }

    public static enum TIME_MODE {
        RELATIVE,
        ABSOLUTE;

    }
}

